/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.Body;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.graph.CompleteBlockGraph;
import soot.toolkits.graph.DummyBlock;

public class BlockGraphConverter {
    public static void addStartStopNodesTo(BlockGraph graph) {
        List<Block> tails;
        int tailCount;
        List<Block> blocks;
        List<Block> heads = graph.getHeads();
        int headCount = heads.size();
        if (!(headCount == 0 || headCount == 1 && heads.get(0) instanceof DummyBlock)) {
            blocks = graph.getBlocks();
            DummyBlock head = new DummyBlock(graph.getBody(), 0);
            head.makeHeadBlock(heads);
            graph.mHeads = Collections.singletonList(head);
            for (Block block : blocks) {
                block.setIndexInMethod(block.getIndexInMethod() + 1);
            }
            ArrayList<Block> newBlocks = new ArrayList<Block>();
            newBlocks.add(head);
            newBlocks.addAll(blocks);
            graph.mBlocks = newBlocks;
        }
        if (!((tailCount = (tails = graph.getTails()).size()) == 0 || tailCount == 1 && tails.get(0) instanceof DummyBlock)) {
            blocks = graph.getBlocks();
            DummyBlock tail = new DummyBlock(graph.getBody(), blocks.size());
            tail.makeTailBlock(tails);
            graph.mTails = Collections.singletonList(tail);
            blocks.add(tail);
        }
    }

    public static void reverse(BlockGraph graph) {
        for (Block block : graph.getBlocks()) {
            List<Block> succs = block.getSuccs();
            List<Block> preds = block.getPreds();
            block.setSuccs(preds);
            block.setPreds(succs);
        }
        List<Block> heads = graph.getHeads();
        List<Block> tails = graph.getTails();
        graph.mHeads = new ArrayList<Block>(tails);
        graph.mTails = new ArrayList<Block>(heads);
    }

    public static void main(String[] args) {
        Scene.v().loadClassAndSupport(args[0]);
        SootClass sc = Scene.v().getSootClass(args[0]);
        SootMethod sm = sc.getMethod(args[1]);
        Body b = sm.retrieveActiveBody();
        CompleteBlockGraph cfg = new CompleteBlockGraph(b);
        System.out.println(cfg);
        BlockGraphConverter.addStartStopNodesTo(cfg);
        System.out.println(cfg);
        BlockGraphConverter.reverse(cfg);
        System.out.println(cfg);
    }
}

