/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Trap;
import soot.Unit;
import soot.jimple.NopStmt;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.DirectedBodyGraph;
import soot.toolkits.graph.UnitGraph;
import soot.util.Chain;

public abstract class BlockGraph
implements DirectedBodyGraph<Block> {
    protected Body mBody;
    protected Chain<Unit> mUnits;
    protected List<Block> mBlocks;
    protected List<Block> mHeads;
    protected List<Block> mTails;

    protected BlockGraph(UnitGraph unitGraph) {
        this.mBody = unitGraph.getBody();
        this.mUnits = this.mBody.getUnits();
        this.buildBlocks(this.computeLeaders(unitGraph), unitGraph);
    }

    protected Set<Unit> computeLeaders(UnitGraph unitGraph) {
        Body body = unitGraph.getBody();
        if (body != this.mBody) {
            throw new RuntimeException("BlockGraph.computeLeaders() called with a UnitGraph that doesn't match its mBody.");
        }
        HashSet<Unit> leaders = new HashSet<Unit>();
        for (Trap trap : body.getTraps()) {
            leaders.add(trap.getHandlerUnit());
        }
        for (Unit u : body.getUnits()) {
            List<Unit> successors;
            if (unitGraph.getPredsOf(u).size() != 1) {
                leaders.add(u);
            }
            if ((successors = unitGraph.getSuccsOf(u)).size() <= 1 && !u.branches()) continue;
            for (Unit next : successors) {
                leaders.add(next);
            }
        }
        return leaders;
    }

    protected Map<Unit, Block> buildBlocks(Set<Unit> leaders, UnitGraph unitGraph) {
        ArrayList<Block> blockList = new ArrayList<Block>(leaders.size());
        ArrayList<Block> headList = new ArrayList<Block>();
        ArrayList<Block> tailList = new ArrayList<Block>();
        HashMap<Unit, Block> unitToBlock = new HashMap<Unit, Block>();
        Object blockHead = null;
        int blockLength = 0;
        Iterator<Unit> unitIt = this.mUnits.iterator();
        if (unitIt.hasNext()) {
            blockHead = unitIt.next();
            if (!leaders.contains(blockHead)) {
                throw new RuntimeException("BlockGraph: first unit not a leader!");
            }
            ++blockLength;
        }
        Unit blockTail = blockHead;
        int indexInMethod = 0;
        while (unitIt.hasNext()) {
            Unit u = unitIt.next();
            if (leaders.contains(u)) {
                this.addBlock((Unit)blockHead, blockTail, indexInMethod, blockLength, (List<Block>)blockList, (Map<Unit, Block>)unitToBlock);
                ++indexInMethod;
                blockHead = u;
                blockLength = 0;
            }
            blockTail = u;
            ++blockLength;
        }
        if (blockLength > 0) {
            this.addBlock((Unit)blockHead, blockTail, indexInMethod, blockLength, blockList, unitToBlock);
        }
        for (Unit headUnit : unitGraph.getHeads()) {
            Block headBlock = (Block)unitToBlock.get(headUnit);
            if (headBlock.getHead() == headUnit) {
                headList.add(headBlock);
                continue;
            }
            throw new RuntimeException("BlockGraph(): head Unit is not the first unit in the corresponding Block!");
        }
        for (Unit tailUnit : unitGraph.getTails()) {
            Block tailBlock = (Block)unitToBlock.get(tailUnit);
            if (tailBlock.getTail() == tailUnit) {
                tailList.add(tailBlock);
                continue;
            }
            throw new RuntimeException("BlockGraph(): tail Unit is not the last unit in the corresponding Block!");
        }
        Iterator<Block> blockIt = blockList.iterator();
        while (blockIt.hasNext()) {
            Block block = blockIt.next();
            List<Unit> predUnits = unitGraph.getPredsOf(block.getHead());
            if (predUnits.isEmpty()) {
                block.setPreds(Collections.emptyList());
            } else {
                ArrayList<Block> predBlocks = new ArrayList<Block>(predUnits.size());
                for (Unit predUnit : predUnits) {
                    assert (predUnit != null);
                    Block predBlock = (Block)unitToBlock.get(predUnit);
                    if (predBlock == null) {
                        throw new RuntimeException("BlockGraph(): block head predecessor (" + predUnit + ") mapped to null block!");
                    }
                    predBlocks.add(predBlock);
                }
                block.setPreds(Collections.unmodifiableList(predBlocks));
                if (block.getHead() == this.mUnits.getFirst()) {
                    headList.add(block);
                }
            }
            List<Unit> succUnits = unitGraph.getSuccsOf(block.getTail());
            if (succUnits.isEmpty()) {
                block.setSuccs(Collections.emptyList());
                if (tailList.contains(block)) continue;
                if (block.getPreds().isEmpty() && block.getHead() == block.getTail() && block.getHead() instanceof NopStmt) {
                    blockIt.remove();
                    continue;
                }
                throw new RuntimeException("Block with no successors is not a tail!: " + block.toString());
            }
            ArrayList<Block> succBlocks = new ArrayList<Block>(succUnits.size());
            for (Unit succUnit : succUnits) {
                assert (succUnit != null);
                Block succBlock = (Block)unitToBlock.get(succUnit);
                if (succBlock == null) {
                    throw new RuntimeException("BlockGraph(): block tail successor (" + succUnit + ") mapped to null block!");
                }
                succBlocks.add(succBlock);
            }
            block.setSuccs(Collections.unmodifiableList(succBlocks));
        }
        blockList.trimToSize();
        this.mBlocks = Collections.unmodifiableList(blockList);
        headList.trimToSize();
        this.mHeads = headList.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(headList);
        tailList.trimToSize();
        this.mTails = tailList.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(tailList);
        return unitToBlock;
    }

    private void addBlock(Unit head, Unit tail, int index, int length, List<Block> blockList, Map<Unit, Block> unitToBlock) {
        Block block = new Block(head, tail, this.mBody, index, length, this);
        blockList.add(block);
        unitToBlock.put(tail, block);
        unitToBlock.put(head, block);
    }

    @Override
    public Body getBody() {
        return this.mBody;
    }

    public List<Block> getBlocks() {
        return this.mBlocks;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Block someBlock : this.mBlocks) {
            buf.append(someBlock.toString()).append('\n');
        }
        return buf.toString();
    }

    @Override
    public List<Block> getHeads() {
        return this.mHeads;
    }

    @Override
    public List<Block> getTails() {
        return this.mTails;
    }

    @Override
    public List<Block> getPredsOf(Block b) {
        return b.getPreds();
    }

    @Override
    public List<Block> getSuccsOf(Block b) {
        return b.getSuccs();
    }

    @Override
    public int size() {
        return this.mBlocks.size();
    }

    @Override
    public Iterator<Block> iterator() {
        return this.mBlocks.iterator();
    }
}

