/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.exceptions;

import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import soot.AnySubType;
import soot.FastHierarchy;
import soot.G;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.options.Options;

public class ThrowableSet {
    private static final boolean INSTRUMENTING = false;
    private final SootClass JAVA_LANG_OBJECT_CLASS = Scene.v().getObjectType().getSootClass();
    protected final Set<RefLikeType> exceptionsIncluded;
    protected final Set<AnySubType> exceptionsExcluded;
    protected Map<Object, ThrowableSet> memoizedAdds;

    protected ThrowableSet(Set<RefLikeType> include, Set<AnySubType> exclude) {
        this.exceptionsIncluded = ThrowableSet.getImmutable(include);
        this.exceptionsExcluded = ThrowableSet.getImmutable(exclude);
    }

    private static <T> Set<T> getImmutable(Set<T> in) {
        if (null == in || in.isEmpty()) {
            return Collections.emptySet();
        }
        if (1 == in.size()) {
            return Collections.singleton(in.iterator().next());
        }
        return Collections.unmodifiableSet(in);
    }

    private static <T extends RefLikeType> Iterator<T> sortedThrowableIterator(Collection<T> coll) {
        if (coll.size() <= 1) {
            return coll.iterator();
        }
        RefLikeType[] array = coll.toArray(new RefLikeType[coll.size()]);
        Arrays.sort(array, new ThrowableComparator());
        return Arrays.asList(array).iterator();
    }

    private ThrowableSet getMemoizedAdds(Object key) {
        return this.memoizedAdds == null ? null : this.memoizedAdds.get(key);
    }

    private void addToMemoizedAdds(Object key, ThrowableSet value) {
        if (this.memoizedAdds == null) {
            this.memoizedAdds = new ConcurrentHashMap<Object, ThrowableSet>();
        }
        this.memoizedAdds.put(key, value);
    }

    public ThrowableSet add(RefType e) throws AlreadyHasExclusionsException {
        if (this.exceptionsIncluded.contains(e)) {
            return this;
        }
        ThrowableSet result = this.getMemoizedAdds(e);
        if (result != null) {
            return result;
        }
        FastHierarchy hierarchy = Scene.v().getOrMakeFastHierarchy();
        boolean eHasNoHierarchy = this.hasNoHierarchy(e);
        for (AnySubType excludedType : this.exceptionsExcluded) {
            RefType exclusionBase = excludedType.getBase();
            if ((!eHasNoHierarchy || !exclusionBase.equals(e)) && (eHasNoHierarchy || !hierarchy.canStoreType(e, exclusionBase))) continue;
            throw new AlreadyHasExclusionsException("ThrowableSet.add(RefType): adding" + e.toString() + " to the set [ " + this.toString() + "] where " + exclusionBase.toString() + " is excluded.");
        }
        if (!eHasNoHierarchy) {
            for (RefLikeType incumbent : this.exceptionsIncluded) {
                if (incumbent instanceof AnySubType) {
                    RefType incumbentBase = ((AnySubType)incumbent).getBase();
                    if (!hierarchy.canStoreType(e, incumbentBase)) continue;
                    this.addToMemoizedAdds(e, this);
                    return this;
                }
                if (incumbent instanceof RefType) continue;
                throw new IllegalStateException("ThrowableSet.add(RefType): Set element " + incumbent.toString() + " is neither a RefType nor an AnySubType.");
            }
        }
        HashSet<RefLikeType> resultSet = new HashSet<RefLikeType>(this.exceptionsIncluded);
        resultSet.add(e);
        result = Manager.v().registerSetIfNew(resultSet, this.exceptionsExcluded);
        this.addToMemoizedAdds(e, result);
        return result;
    }

    private boolean hasNoHierarchy(RefType type) {
        SootClass sootClass = type.getSootClass();
        return !sootClass.hasSuperclass() && this.JAVA_LANG_OBJECT_CLASS != sootClass;
    }

    public ThrowableSet add(AnySubType e) throws AlreadyHasExclusionsException {
        ThrowableSet result = this.getMemoizedAdds(e);
        if (result != null) {
            return result;
        }
        SootClass objectClass = Scene.v().getObjectType().getSootClass();
        FastHierarchy hierarchy = Scene.v().getOrMakeFastHierarchy();
        RefType newBase = e.getBase();
        boolean newBaseHasNoHierarchy = this.hasNoHierarchy(newBase);
        for (AnySubType excludedType : this.exceptionsExcluded) {
            RefType exclusionBase = excludedType.getBase();
            boolean exclusionBaseHasNoHierarchy = !exclusionBase.getSootClass().hasSuperclass() && exclusionBase.getSootClass() != objectClass;
            boolean isExcluded = exclusionBaseHasNoHierarchy && exclusionBase.equals(newBase);
            if (!(isExcluded |= !exclusionBaseHasNoHierarchy && (hierarchy.canStoreType(newBase, exclusionBase) || hierarchy.canStoreType(exclusionBase, newBase)))) continue;
            throw new AlreadyHasExclusionsException("ThrowableSet.add(" + e.toString() + ") to the set [ " + this.toString() + "] where " + exclusionBase.toString() + " is excluded.");
        }
        if (this.exceptionsIncluded.contains(e)) {
            return this;
        }
        int changes = 0;
        boolean addNewException = true;
        HashSet<RefLikeType> resultSet = new HashSet<RefLikeType>();
        for (RefLikeType incumbent : this.exceptionsIncluded) {
            if (incumbent instanceof RefType) {
                if (hierarchy.canStoreType(incumbent, newBase)) {
                    ++changes;
                    continue;
                }
                resultSet.add(incumbent);
                continue;
            }
            if (incumbent instanceof AnySubType) {
                RefType incumbentBase = ((AnySubType)incumbent).getBase();
                if (newBaseHasNoHierarchy) {
                    if (incumbentBase.equals(newBase)) continue;
                    resultSet.add(incumbent);
                    continue;
                }
                if (hierarchy.canStoreType(newBase, incumbentBase)) {
                    addNewException = false;
                    resultSet.add(incumbent);
                    continue;
                }
                if (hierarchy.canStoreType(incumbentBase, newBase)) {
                    ++changes;
                    continue;
                }
                resultSet.add(incumbent);
                continue;
            }
            throw new IllegalStateException("ThrowableSet.add(AnySubType): Set element " + incumbent.toString() + " is neither a RefType nor an AnySubType.");
        }
        if (addNewException) {
            resultSet.add(e);
            ++changes;
        }
        result = changes > 0 ? Manager.v().registerSetIfNew(resultSet, this.exceptionsExcluded) : this;
        this.addToMemoizedAdds(e, result);
        return result;
    }

    public ThrowableSet add(ThrowableSet s) throws AlreadyHasExclusionsException {
        if (this.exceptionsExcluded.size() > 0 || s.exceptionsExcluded.size() > 0) {
            throw new AlreadyHasExclusionsException("ThrowableSet.Add(ThrowableSet): attempt to add to [" + this.toString() + "] after removals recorded.");
        }
        ThrowableSet result = this.getMemoizedAdds(s);
        if (result == null) {
            result = this.add(s.exceptionsIncluded);
            this.addToMemoizedAdds(s, result);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.exceptionsIncluded.isEmpty();
    }

    private ThrowableSet add(Set<RefLikeType> addedExceptions) {
        HashSet<RefLikeType> resultSet = new HashSet<RefLikeType>(this.exceptionsIncluded);
        int changes = 0;
        FastHierarchy hierarchy = Scene.v().getOrMakeFastHierarchy();
        for (RefLikeType newType : addedExceptions) {
            if (resultSet.contains(newType)) continue;
            boolean addNewType = true;
            if (newType instanceof RefType) {
                for (RefLikeType incumbentType : resultSet) {
                    if (incumbentType instanceof RefType) {
                        if (newType != incumbentType) continue;
                        throw new IllegalStateException("ThrowableSet.add(Set): resultSet.contains() failed to screen duplicate RefType " + newType);
                    }
                    if (incumbentType instanceof AnySubType) {
                        RefType incumbentBase = ((AnySubType)incumbentType).getBase();
                        if (!hierarchy.canStoreType(newType, incumbentBase)) continue;
                        addNewType = false;
                        continue;
                    }
                    throw new IllegalStateException("ThrowableSet.add(Set): incumbent Set element " + incumbentType + " is neither a RefType nor an AnySubType.");
                }
            } else if (newType instanceof AnySubType) {
                RefType newBase = ((AnySubType)newType).getBase();
                Iterator j = resultSet.iterator();
                while (j.hasNext()) {
                    RefType incumbentBase;
                    RefLikeType incumbentType = (RefLikeType)j.next();
                    if (incumbentType instanceof RefType) {
                        incumbentBase = (RefType)incumbentType;
                        if (!hierarchy.canStoreType(incumbentBase, newBase)) continue;
                        j.remove();
                        ++changes;
                        continue;
                    }
                    if (incumbentType instanceof AnySubType) {
                        incumbentBase = ((AnySubType)incumbentType).getBase();
                        if (newBase == incumbentBase) {
                            throw new IllegalStateException("ThrowableSet.add(Set): resultSet.contains() failed to screen duplicate AnySubType " + newBase);
                        }
                        if (hierarchy.canStoreType(incumbentBase, newBase)) {
                            j.remove();
                            ++changes;
                            continue;
                        }
                        if (!hierarchy.canStoreType(newBase, incumbentBase)) continue;
                        addNewType = false;
                        continue;
                    }
                    throw new IllegalStateException("ThrowableSet.add(Set): old Set element " + incumbentType + " is neither a RefType nor an AnySubType.");
                }
            } else {
                throw new IllegalArgumentException("ThrowableSet.add(Set): new Set element " + newType + " is neither a RefType nor an AnySubType.");
            }
            if (!addNewType) continue;
            ++changes;
            resultSet.add(newType);
        }
        ThrowableSet result = null;
        result = changes > 0 ? Manager.v().registerSetIfNew(resultSet, this.exceptionsExcluded) : this;
        return result;
    }

    private ThrowableSet remove(Set<RefLikeType> removedExceptions) {
        if (removedExceptions.isEmpty()) {
            return this;
        }
        int changes = 0;
        HashSet<RefLikeType> resultSet = new HashSet<RefLikeType>(this.exceptionsIncluded);
        for (RefLikeType tp : removedExceptions) {
            if (!(tp instanceof RefType) || !resultSet.remove(tp)) continue;
            ++changes;
        }
        ThrowableSet result = null;
        result = changes > 0 ? Manager.v().registerSetIfNew(resultSet, this.exceptionsExcluded) : this;
        return result;
    }

    public ThrowableSet remove(ThrowableSet s) {
        if (this.exceptionsExcluded.size() > 0 || s.exceptionsExcluded.size() > 0) {
            throw new AlreadyHasExclusionsException("ThrowableSet.Add(ThrowableSet): attempt to add to [" + this.toString() + "] after removals recorded.");
        }
        return this.remove(s.exceptionsIncluded);
    }

    public boolean catchableAs(RefType catcher) {
        FastHierarchy h = Scene.v().getOrMakeFastHierarchy();
        boolean catcherHasNoHierarchy = this.hasNoHierarchy(catcher);
        if (this.exceptionsExcluded.size() > 0) {
            for (AnySubType exclusion : this.exceptionsExcluded) {
                if (!(catcherHasNoHierarchy ? exclusion.getBase().equals(catcher) : h.canStoreType(catcher, exclusion.getBase()))) continue;
                return false;
            }
        }
        if (this.exceptionsIncluded.contains(catcher)) {
            return true;
        }
        for (RefLikeType thrownType : this.exceptionsIncluded) {
            if (thrownType instanceof RefType) {
                if (thrownType == catcher) {
                    throw new IllegalStateException("ThrowableSet.catchableAs(RefType): exceptions.contains() failed to match contained RefType " + catcher);
                }
                if (catcherHasNoHierarchy || !h.canStoreType(thrownType, catcher)) continue;
                return true;
            }
            RefType thrownBase = ((AnySubType)thrownType).getBase();
            if (!(catcherHasNoHierarchy ? thrownBase.equals(catcher) || thrownBase.getClassName().equals("java.lang.Throwable") : h.canStoreType(thrownBase, catcher) || h.canStoreType(catcher, thrownBase))) continue;
            return true;
        }
        return false;
    }

    public Pair whichCatchableAs(RefType catcher) {
        FastHierarchy h = Scene.v().getOrMakeFastHierarchy();
        Set<RefLikeType> caughtIncluded = null;
        Set<AnySubType> caughtExcluded = null;
        Set<RefLikeType> uncaughtIncluded = null;
        Set<AnySubType> uncaughtExcluded = null;
        boolean catcherHasNoHierarchy = this.hasNoHierarchy(catcher);
        for (AnySubType exclusion : this.exceptionsExcluded) {
            RefType exclusionBase = exclusion.getBase();
            if (catcherHasNoHierarchy && exclusionBase.equals(catcher)) {
                return new Pair(Manager.v().EMPTY, this);
            }
            if (h.canStoreType(catcher, exclusionBase)) {
                return new Pair(Manager.v().EMPTY, this);
            }
            if (h.canStoreType(exclusionBase, catcher)) {
                caughtExcluded = this.addExceptionToSet(exclusion, caughtExcluded);
                continue;
            }
            uncaughtExcluded = this.addExceptionToSet(exclusion, uncaughtExcluded);
        }
        for (RefLikeType inclusion : this.exceptionsIncluded) {
            if (inclusion instanceof RefType) {
                if (catcherHasNoHierarchy) {
                    if (inclusion.equals(catcher)) {
                        caughtIncluded = this.addExceptionToSet(inclusion, caughtIncluded);
                        continue;
                    }
                    uncaughtIncluded = this.addExceptionToSet(inclusion, uncaughtIncluded);
                    continue;
                }
                if (h.canStoreType(inclusion, catcher)) {
                    caughtIncluded = this.addExceptionToSet(inclusion, caughtIncluded);
                    continue;
                }
                uncaughtIncluded = this.addExceptionToSet(inclusion, uncaughtIncluded);
                continue;
            }
            RefType base = ((AnySubType)inclusion).getBase();
            if (catcherHasNoHierarchy) {
                if (base.equals(catcher)) {
                    caughtIncluded = this.addExceptionToSet(inclusion, caughtIncluded);
                    continue;
                }
                if (base.getClassName().equals("java.lang.Throwable")) {
                    caughtIncluded = this.addExceptionToSet(catcher, caughtIncluded);
                }
                uncaughtIncluded = this.addExceptionToSet(inclusion, uncaughtIncluded);
                continue;
            }
            if (h.canStoreType(base, catcher)) {
                caughtIncluded = this.addExceptionToSet(inclusion, caughtIncluded);
                continue;
            }
            if (h.canStoreType(catcher, base)) {
                uncaughtIncluded = this.addExceptionToSet(inclusion, uncaughtIncluded);
                uncaughtExcluded = this.addExceptionToSet(AnySubType.v(catcher), uncaughtExcluded);
                caughtIncluded = this.addExceptionToSet(AnySubType.v(catcher), caughtIncluded);
                continue;
            }
            uncaughtIncluded = this.addExceptionToSet(inclusion, uncaughtIncluded);
        }
        ThrowableSet caughtSet = Manager.v().registerSetIfNew(caughtIncluded, caughtExcluded);
        ThrowableSet uncaughtSet = Manager.v().registerSetIfNew(uncaughtIncluded, uncaughtExcluded);
        return new Pair(caughtSet, uncaughtSet);
    }

    private <T> Set<T> addExceptionToSet(T e, Set<T> set) {
        if (set == null) {
            set = new HashSet<T>();
        }
        set.add(e);
        return set;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.toBriefString());
        buffer.append(":\n  ");
        for (RefLikeType refLikeType : this.exceptionsIncluded) {
            buffer.append('+');
            buffer.append(refLikeType == null ? "null" : refLikeType.toString());
        }
        for (RefLikeType refLikeType : this.exceptionsExcluded) {
            buffer.append('-');
            buffer.append(refLikeType.toString());
        }
        return buffer.toString();
    }

    public String toBriefString() {
        return super.toString();
    }

    public String toAbbreviatedString() {
        return this.toAbbreviatedString(this.exceptionsIncluded, '+') + this.toAbbreviatedString(this.exceptionsExcluded, '-');
    }

    private String toAbbreviatedString(Set<? extends RefLikeType> s, char connector) {
        String JAVA_LANG = "java.lang.";
        String EXCEPTION = "Exception";
        Set<RefLikeType> vmErrorThrowables = Manager.v().VM_ERRORS.exceptionsIncluded;
        boolean containsAllVmErrors = s.containsAll(vmErrorThrowables);
        StringBuffer buf = new StringBuffer();
        if (containsAllVmErrors) {
            buf.append(connector);
            buf.append("vmErrors");
        }
        Iterator<? extends RefLikeType> it = ThrowableSet.sortedThrowableIterator(s);
        while (it.hasNext()) {
            RefLikeType reflikeType = it.next();
            RefType baseType = null;
            if (reflikeType instanceof RefType) {
                baseType = (RefType)reflikeType;
                if (containsAllVmErrors && vmErrorThrowables.contains(baseType)) continue;
                buf.append(connector);
            } else if (reflikeType instanceof AnySubType) {
                buf.append(connector);
                buf.append('(');
                baseType = ((AnySubType)reflikeType).getBase();
            } else {
                throw new RuntimeException("Unsupported type " + reflikeType.getClass().getName());
            }
            String typeName = baseType.toString();
            int start = 0;
            int end = typeName.length();
            if (typeName.startsWith("java.lang.")) {
                start += "java.lang.".length();
            }
            if (typeName.endsWith("Exception")) {
                end -= "Exception".length();
            }
            buf.append(typeName, start, end);
            if (!(reflikeType instanceof AnySubType)) continue;
            buf.append(')');
        }
        return buf.toString();
    }

    Collection<RefLikeType> typesIncluded() {
        return this.exceptionsIncluded;
    }

    Collection<AnySubType> typesExcluded() {
        return this.exceptionsExcluded;
    }

    Map<Object, ThrowableSet> getMemoizedAdds() {
        if (this.memoizedAdds == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.memoizedAdds);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.exceptionsIncluded.hashCode();
        result = 31 * result + this.exceptionsExcluded.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThrowableSet other = (ThrowableSet)obj;
        return this.exceptionsIncluded.equals(other.exceptionsIncluded) && this.exceptionsExcluded.equals(other.exceptionsExcluded);
    }

    private static class ThrowableComparator<T extends RefLikeType>
    implements Comparator<T> {
        private ThrowableComparator() {
        }

        private static RefType baseType(RefLikeType o) {
            if (o instanceof AnySubType) {
                return ((AnySubType)o).getBase();
            }
            return (RefType)o;
        }

        @Override
        public int compare(T o1, T o2) {
            RefType t2;
            RefType t1 = ThrowableComparator.baseType(o1);
            if (t1.equals(t2 = ThrowableComparator.baseType(o2))) {
                if (o1 instanceof AnySubType) {
                    if (o2 instanceof AnySubType) {
                        return 0;
                    }
                    return -1;
                }
                if (o2 instanceof AnySubType) {
                    return 1;
                }
                return 0;
            }
            return t1.toString().compareTo(t2.toString());
        }
    }

    public static class Pair {
        private ThrowableSet caught;
        private ThrowableSet uncaught;

        protected Pair(ThrowableSet caught, ThrowableSet uncaught) {
            this.caught = caught;
            this.uncaught = uncaught;
        }

        public ThrowableSet getCaught() {
            return this.caught;
        }

        public ThrowableSet getUncaught() {
            return this.uncaught;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair tsp = (Pair)o;
            return this.caught.equals(tsp.caught) && this.uncaught.equals(tsp.uncaught);
        }

        public int hashCode() {
            int result = 31;
            result = 37 * result + this.caught.hashCode();
            result = 37 * result + this.uncaught.hashCode();
            return result;
        }
    }

    public static class AlreadyHasExclusionsException
    extends IllegalStateException {
        private static final long serialVersionUID = 6785184160868722359L;

        public AlreadyHasExclusionsException(String s) {
            super(s);
        }
    }

    public static class Manager {
        public final ThrowableSet EMPTY;
        public final ThrowableSet RESOLVE_CLASS_ERRORS;
        public final RefType RUNTIME_EXCEPTION;
        public final RefType ARITHMETIC_EXCEPTION;
        public final RefType ARRAY_STORE_EXCEPTION;
        public final RefType CLASS_CAST_EXCEPTION;
        public final RefType ILLEGAL_MONITOR_STATE_EXCEPTION;
        public final RefType INDEX_OUT_OF_BOUNDS_EXCEPTION;
        public final RefType ARRAY_INDEX_OUT_OF_BOUNDS_EXCEPTION;
        public final RefType NEGATIVE_ARRAY_SIZE_EXCEPTION;
        public final RefType NULL_POINTER_EXCEPTION;
        public final RefType INSTANTIATION_ERROR;
        final ThrowableSet ALL_THROWABLES;
        final ThrowableSet VM_ERRORS;
        final ThrowableSet RESOLVE_FIELD_ERRORS;
        final ThrowableSet RESOLVE_METHOD_ERRORS;
        final ThrowableSet INITIALIZATION_ERRORS;
        private final Map<ThrowableSet, ThrowableSet> registry = CacheBuilder.newBuilder().weakValues().build().asMap();
        private final int removesFromMap = 0;
        private final int removesFromMemo = 0;
        private int addsOfRefType = 0;
        private int addsOfAnySubType = 0;
        private int addsOfSet = 0;
        private int addsInclusionFromMap = 0;
        private int addsInclusionFromMemo = 0;
        private int addsInclusionFromSearch = 0;
        private int addsInclusionInterrupted = 0;
        private int addsExclusionWithSearch = 0;
        private int addsExclusionWithoutSearch = 0;
        private int removesOfAnySubType = 0;
        private int removesFromSearch = 0;
        private int registrationCalls = 0;
        private int catchableAsQueries = 0;
        private int catchableAsFromMap = 0;
        private int catchableAsFromSearch = 0;

        public Manager(Singletons.Global g) {
            Scene scene = Scene.v();
            this.RUNTIME_EXCEPTION = scene.getRefTypeUnsafe("java.lang.RuntimeException");
            this.ARITHMETIC_EXCEPTION = scene.getRefTypeUnsafe("java.lang.ArithmeticException");
            this.ARRAY_STORE_EXCEPTION = scene.getRefTypeUnsafe("java.lang.ArrayStoreException");
            this.CLASS_CAST_EXCEPTION = scene.getRefTypeUnsafe("java.lang.ClassCastException");
            this.ILLEGAL_MONITOR_STATE_EXCEPTION = scene.getRefTypeUnsafe("java.lang.IllegalMonitorStateException");
            this.INDEX_OUT_OF_BOUNDS_EXCEPTION = scene.getRefTypeUnsafe("java.lang.IndexOutOfBoundsException");
            this.ARRAY_INDEX_OUT_OF_BOUNDS_EXCEPTION = scene.getRefTypeUnsafe("java.lang.ArrayIndexOutOfBoundsException");
            this.NEGATIVE_ARRAY_SIZE_EXCEPTION = scene.getRefTypeUnsafe("java.lang.NegativeArraySizeException");
            this.NULL_POINTER_EXCEPTION = scene.getRefTypeUnsafe("java.lang.NullPointerException");
            this.INSTANTIATION_ERROR = scene.getRefType("java.lang.InstantiationError");
            this.EMPTY = this.registerSetIfNew(null, null);
            HashSet<RefLikeType> allThrowablesSet = new HashSet<RefLikeType>();
            allThrowablesSet.add(AnySubType.v(scene.getRefType("java.lang.Throwable")));
            this.ALL_THROWABLES = this.registerSetIfNew(allThrowablesSet, null);
            HashSet<RefLikeType> vmErrorSet = new HashSet<RefLikeType>();
            vmErrorSet.add(scene.getRefTypeUnsafe("java.lang.InternalError"));
            vmErrorSet.add(scene.getRefTypeUnsafe("java.lang.OutOfMemoryError"));
            vmErrorSet.add(scene.getRefTypeUnsafe("java.lang.StackOverflowError"));
            vmErrorSet.add(scene.getRefTypeUnsafe("java.lang.UnknownError"));
            vmErrorSet.add(scene.getRefTypeUnsafe("java.lang.ThreadDeath"));
            this.VM_ERRORS = this.registerSetIfNew(vmErrorSet, null);
            HashSet<RefLikeType> resolveClassErrorSet = new HashSet<RefLikeType>();
            resolveClassErrorSet.add(scene.getRefType("java.lang.ClassCircularityError"));
            if (!Options.v().j2me()) {
                resolveClassErrorSet.add(AnySubType.v(Scene.v().getRefTypeUnsafe("java.lang.ClassFormatError")));
            }
            resolveClassErrorSet.add(scene.getRefTypeUnsafe("java.lang.IllegalAccessError"));
            resolveClassErrorSet.add(scene.getRefTypeUnsafe("java.lang.IncompatibleClassChangeError"));
            resolveClassErrorSet.add(scene.getRefTypeUnsafe("java.lang.LinkageError"));
            resolveClassErrorSet.add(scene.getRefTypeUnsafe("java.lang.NoClassDefFoundError"));
            resolveClassErrorSet.add(scene.getRefTypeUnsafe("java.lang.VerifyError"));
            this.RESOLVE_CLASS_ERRORS = this.registerSetIfNew(resolveClassErrorSet, null);
            HashSet<RefLikeType> resolveFieldErrorSet = new HashSet<RefLikeType>(resolveClassErrorSet);
            resolveFieldErrorSet.add(scene.getRefTypeUnsafe("java.lang.NoSuchFieldError"));
            this.RESOLVE_FIELD_ERRORS = this.registerSetIfNew(resolveFieldErrorSet, null);
            HashSet<RefLikeType> resolveMethodErrorSet = new HashSet<RefLikeType>(resolveClassErrorSet);
            resolveMethodErrorSet.add(scene.getRefTypeUnsafe("java.lang.AbstractMethodError"));
            resolveMethodErrorSet.add(scene.getRefTypeUnsafe("java.lang.NoSuchMethodError"));
            resolveMethodErrorSet.add(scene.getRefTypeUnsafe("java.lang.UnsatisfiedLinkError"));
            this.RESOLVE_METHOD_ERRORS = this.registerSetIfNew(resolveMethodErrorSet, null);
            HashSet<RefLikeType> initializationErrorSet = new HashSet<RefLikeType>();
            initializationErrorSet.add(AnySubType.v(scene.getRefTypeUnsafe("java.lang.Error")));
            this.INITIALIZATION_ERRORS = this.registerSetIfNew(initializationErrorSet, null);
        }

        public static Manager v() {
            return G.v().soot_toolkits_exceptions_ThrowableSet_Manager();
        }

        protected ThrowableSet registerSetIfNew(Set<RefLikeType> include, Set<AnySubType> exclude) {
            ThrowableSet result = new ThrowableSet(include, exclude);
            ThrowableSet ref = this.registry.get(result);
            if (null != ref) {
                return ref;
            }
            this.registry.put(result, result);
            return result;
        }

        public String reportInstrumentation() {
            int setCount = this.registry.size();
            StringBuffer buf = new StringBuffer("registeredSets: ").append(setCount).append("\naddsOfRefType: ").append(this.addsOfRefType).append("\naddsOfAnySubType: ").append(this.addsOfAnySubType).append("\naddsOfSet: ").append(this.addsOfSet).append("\naddsInclusionFromMap: ").append(this.addsInclusionFromMap).append("\naddsInclusionFromMemo: ").append(this.addsInclusionFromMemo).append("\naddsInclusionFromSearch: ").append(this.addsInclusionFromSearch).append("\naddsInclusionInterrupted: ").append(this.addsInclusionInterrupted).append("\naddsExclusionWithoutSearch: ").append(this.addsExclusionWithoutSearch).append("\naddsExclusionWithSearch: ").append(this.addsExclusionWithSearch).append("\nremovesOfAnySubType: ").append(this.removesOfAnySubType).append("\nremovesFromMap: ").append(0).append("\nremovesFromMemo: ").append(0).append("\nremovesFromSearch: ").append(this.removesFromSearch).append("\nregistrationCalls: ").append(this.registrationCalls).append("\ncatchableAsQueries: ").append(this.catchableAsQueries).append("\ncatchableAsFromMap: ").append(this.catchableAsFromMap).append("\ncatchableAsFromSearch: ").append(this.catchableAsFromSearch).append('\n');
            return buf.toString();
        }

        Set<ThrowableSet> getThrowableSets() {
            return this.registry.keySet();
        }
    }
}

