/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.astmetrics;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import polyglot.ast.ClassDecl;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.LocalDecl;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.visit.NodeVisitor;
import soot.options.Options;
import soot.toolkits.astmetrics.ASTMetric;
import soot.toolkits.astmetrics.ClassData;
import soot.toolkits.astmetrics.MetricData;

public class IdentifiersMetric
extends ASTMetric {
    private static final Logger logger = LoggerFactory.getLogger(IdentifiersMetric.class);
    double nameComplexity = 0.0;
    double nameCount = 0.0;
    int dictionarySize = 0;
    ArrayList<String> dictionary;
    HashMap<String, Double> names;

    public IdentifiersMetric(Node astNode) {
        super(astNode);
        this.initializeDictionary();
    }

    private void initializeDictionary() {
        String line;
        BufferedReader br = null;
        this.dictionary = new ArrayList();
        this.names = new HashMap();
        InputStream is = ClassLoader.getSystemResourceAsStream("mydict.txt");
        if (is != null) {
            br = new BufferedReader(new InputStreamReader(is));
            try {
                while ((line = br.readLine()) != null) {
                    this.addWord(line);
                }
            }
            catch (IOException ioexc) {
                logger.debug("" + ioexc.getMessage());
            }
        }
        if ((is = ClassLoader.getSystemResourceAsStream("soot/toolkits/astmetrics/dict.txt")) != null) {
            br = new BufferedReader(new InputStreamReader(is));
            try {
                while ((line = br.readLine()) != null) {
                    this.addWord(line.trim().toLowerCase());
                }
            }
            catch (IOException ioexc) {
                logger.debug("" + ioexc.getMessage());
            }
        }
        if ((this.dictionarySize = this.dictionary.size()) == 0) {
            logger.debug("Error reading in dictionary file(s)");
        } else if (Options.v().verbose()) {
            logger.debug("Read " + this.dictionarySize + " words in from dictionary file(s)");
        }
        try {
            is.close();
        }
        catch (IOException e) {
            logger.debug("" + e.getMessage());
        }
        try {
            if (br != null) {
                br.close();
            }
        }
        catch (IOException e) {
            logger.debug("" + e.getMessage());
        }
    }

    private void addWord(String word) {
        if (this.dictionarySize == 0 || word.compareTo(this.dictionary.get(this.dictionarySize - 1)) > 0) {
            this.dictionary.add(word);
        } else {
            int i;
            for (i = 0; i < this.dictionarySize && word.compareTo(this.dictionary.get(i)) > 0; ++i) {
            }
            if (word.compareTo(this.dictionary.get(i)) == 0) {
                return;
            }
            this.dictionary.add(i, word);
        }
        ++this.dictionarySize;
    }

    @Override
    public void reset() {
        this.nameComplexity = 0.0;
        this.nameCount = 0.0;
    }

    @Override
    public void addMetrics(ClassData data) {
        data.addMetric(new MetricData("NameComplexity", new Double(this.nameComplexity)));
        data.addMetric(new MetricData("NameCount", new Double(this.nameCount)));
    }

    @Override
    public NodeVisitor enter(Node parent, Node n) {
        double multiplier = 1.0;
        String name = null;
        if (n instanceof ClassDecl) {
            name = ((ClassDecl)n).name();
            multiplier = 3.0;
            this.nameCount += 1.0;
        } else if (n instanceof MethodDecl) {
            name = ((MethodDecl)n).name();
            multiplier = 4.0;
            this.nameCount += 1.0;
        } else if (n instanceof FieldDecl) {
            name = ((FieldDecl)n).name();
            multiplier = 2.0;
            this.nameCount += 1.0;
        } else if (n instanceof Formal) {
            name = ((Formal)n).name();
            multiplier = 1.5;
            this.nameCount += 1.0;
        } else if (n instanceof LocalDecl) {
            name = ((LocalDecl)n).name();
            this.nameCount += 1.0;
        }
        if (name != null) {
            this.nameComplexity += multiplier * this.computeNameComplexity(name);
        }
        return this.enter(n);
    }

    private double computeNameComplexity(String name) {
        if (this.names.containsKey(name)) {
            return this.names.get(name);
        }
        ArrayList<String> strings = new ArrayList<String>();
        String tmp = "";
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c > '@' && c < '[' || c > '`' && c < '{') {
                tmp = tmp + c;
                continue;
            }
            if (tmp.length() <= 0) continue;
            strings.add(tmp);
            tmp = "";
        }
        if (tmp.length() > 0) {
            strings.add(tmp);
        }
        ArrayList<String> tokens = new ArrayList<String>();
        block1: for (int i = 0; i < strings.size(); ++i) {
            tmp = (String)strings.get(i);
            while (tmp.length() > 0) {
                int idx;
                int caps = this.countCaps(tmp);
                if (caps == 0) {
                    idx = this.findCap(tmp);
                    if (idx > 0) {
                        tokens.add(tmp.substring(0, idx));
                        tmp = tmp.substring(idx, tmp.length());
                        continue;
                    }
                    tokens.add(tmp.substring(0, tmp.length()));
                    continue block1;
                }
                if (caps == 1) {
                    idx = this.findCap(tmp.substring(1)) + 1;
                    if (idx > 0) {
                        tokens.add(tmp.substring(0, idx));
                        tmp = tmp.substring(idx, tmp.length());
                        continue;
                    }
                    tokens.add(tmp.substring(0, tmp.length()));
                    continue block1;
                }
                if (caps < tmp.length()) {
                    tokens.add(tmp.substring(0, caps - 1).toLowerCase());
                    tmp = tmp.substring(caps);
                    continue;
                }
                tokens.add(tmp.substring(0, caps).toLowerCase());
                continue block1;
            }
        }
        double words = 0.0;
        double complexity = 0.0;
        for (int i = 0; i < tokens.size(); ++i) {
            if (!this.dictionary.contains(tokens.get(i))) continue;
            words += 1.0;
        }
        if (words > 0.0) {
            complexity = (double)tokens.size() / words;
        }
        this.names.put(name, new Double(complexity + this.computeCharComplexity(name)));
        return complexity;
    }

    private double computeCharComplexity(String name) {
        int count = 0;
        int last = 0;
        int lng = name.length();
        for (int index = 0; index < lng; ++index) {
            char c = name.charAt(index);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                ++last;
                continue;
            }
            if (last > 1) {
                count += last;
            }
            last = 0;
        }
        double complexity = lng - count;
        if (complexity > 0.0) {
            return (double)lng / complexity;
        }
        return lng;
    }

    private int countCaps(String name) {
        char c;
        int caps;
        for (caps = 0; caps < name.length() && (c = name.charAt(caps)) > '@' && c < '['; ++caps) {
        }
        return caps;
    }

    private int findCap(String name) {
        for (int idx = 0; idx < name.length(); ++idx) {
            char c = name.charAt(idx);
            if (c <= '@' || c >= '[') continue;
            return idx;
        }
        return -1;
    }
}

