/*
 * Decompiled with CFR 0.152.
 */
package soot.toDex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jf.dexlib2.Opcode;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.LongType;
import soot.RefLikeType;
import soot.RefType;
import soot.ShortType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.toDex.Register;

public class SootToDexUtils {
    private static final Map<Class<? extends Type>, String> sootToDexTypeDescriptor = new HashMap<Class<? extends Type>, String>();

    public static String getDexTypeDescriptor(Type sootType) {
        if (sootType == null) {
            throw new NullPointerException("Soot type was null");
        }
        String typeDesc = sootType instanceof RefType ? SootToDexUtils.getDexClassName(((RefType)sootType).getClassName()) : (sootType instanceof ArrayType ? SootToDexUtils.getDexArrayTypeDescriptor((ArrayType)sootType) : sootToDexTypeDescriptor.get(sootType.getClass()));
        if (typeDesc == null || typeDesc.isEmpty()) {
            throw new RuntimeException("Could not create type descriptor for class " + sootType);
        }
        return typeDesc;
    }

    public static String getDexClassName(String dottedClassName) {
        if (dottedClassName == null || dottedClassName.isEmpty()) {
            throw new RuntimeException("Empty class name detected");
        }
        String slashedName = dottedClassName.replace('.', '/');
        if (slashedName.startsWith("L") && slashedName.endsWith(";")) {
            return slashedName;
        }
        return "L" + slashedName + ";";
    }

    public static int getDexAccessFlags(SootMethod m) {
        int dexAccessFlags = m.getModifiers();
        if (m.isConstructor() || m.getName().equals("<clinit>")) {
            dexAccessFlags |= 0x10000;
        }
        if (m.isSynchronized()) {
            dexAccessFlags |= 0x20000;
            if (!m.isNative()) {
                dexAccessFlags &= 0xFFFFFFDF;
            }
        }
        return dexAccessFlags;
    }

    public static String getArrayTypeDescriptor(ArrayType type) {
        Type baseType = type.numDimensions > 1 ? ArrayType.v(type.baseType, 1) : type.baseType;
        return SootToDexUtils.getDexTypeDescriptor(baseType);
    }

    private static String getDexArrayTypeDescriptor(ArrayType sootArray) {
        if (sootArray.numDimensions > 255) {
            throw new RuntimeException("dex does not support more than 255 dimensions! " + sootArray + " has " + sootArray.numDimensions);
        }
        String baseTypeDescriptor = SootToDexUtils.getDexTypeDescriptor(sootArray.baseType);
        StringBuilder sb = new StringBuilder(sootArray.numDimensions + baseTypeDescriptor.length());
        for (int i = 0; i < sootArray.numDimensions; ++i) {
            sb.append('[');
        }
        sb.append(baseTypeDescriptor);
        return sb.toString();
    }

    public static boolean isObject(String typeDescriptor) {
        if (typeDescriptor.isEmpty()) {
            return false;
        }
        char first = typeDescriptor.charAt(0);
        return first == 'L' || first == '[';
    }

    public static boolean isObject(Type sootType) {
        return sootType instanceof RefLikeType;
    }

    public static boolean isWide(String typeDescriptor) {
        return typeDescriptor.equals("J") || typeDescriptor.equals("D");
    }

    public static boolean isWide(Type sootType) {
        return sootType instanceof LongType || sootType instanceof DoubleType;
    }

    public static int getRealRegCount(List<Register> regs) {
        int regCount = 0;
        for (Register r : regs) {
            Type regType = r.getType();
            regCount += SootToDexUtils.getDexWords(regType);
        }
        return regCount;
    }

    public static int getDexWords(Type sootType) {
        return SootToDexUtils.isWide(sootType) ? 2 : 1;
    }

    public static int getDexWords(List<Type> sootTypes) {
        int dexWords = 0;
        for (Type t : sootTypes) {
            dexWords += SootToDexUtils.getDexWords(t);
        }
        return dexWords;
    }

    public static int getOutWordCount(Collection<Unit> units) {
        int outWords = 0;
        for (Unit u : units) {
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr()) continue;
            int wordsForParameters = 0;
            InvokeExpr invocation = stmt.getInvokeExpr();
            List<Value> args = invocation.getArgs();
            for (Value arg : args) {
                wordsForParameters += SootToDexUtils.getDexWords(arg.getType());
            }
            if (!invocation.getMethod().isStatic()) {
                ++wordsForParameters;
            }
            if (wordsForParameters <= outWords) continue;
            outWords = wordsForParameters;
        }
        return outWords;
    }

    public static boolean fitsSigned4(long literal) {
        return literal >= -8L && literal <= 7L;
    }

    public static boolean fitsSigned8(long literal) {
        return literal >= -128L && literal <= 127L;
    }

    public static boolean fitsSigned16(long literal) {
        return literal >= -32768L && literal <= 32767L;
    }

    public static boolean fitsSigned32(long literal) {
        return literal >= Integer.MIN_VALUE && literal <= Integer.MAX_VALUE;
    }

    public static boolean isNormalMove(Opcode opc) {
        return opc.name.startsWith("move") && !opc.name.startsWith("move-result");
    }

    public static List<String> splitSignature(String sig) {
        ArrayList<String> split = new ArrayList<String>();
        int len = sig.length();
        int i = 0;
        int j = 0;
        while (i < len) {
            char c = sig.charAt(i);
            if (c == 'L') {
                for (j = i + 1; j < len; ++j) {
                    c = sig.charAt(j);
                    if (c == ';') {
                        ++j;
                    } else if (c != '<') {
                        continue;
                    }
                    break;
                }
            } else {
                for (j = i + 1; j < len && sig.charAt(j) != 'L'; ++j) {
                }
            }
            split.add(sig.substring(i, j));
            i = j;
        }
        return split;
    }

    static {
        sootToDexTypeDescriptor.put(BooleanType.class, "Z");
        sootToDexTypeDescriptor.put(ByteType.class, "B");
        sootToDexTypeDescriptor.put(CharType.class, "C");
        sootToDexTypeDescriptor.put(DoubleType.class, "D");
        sootToDexTypeDescriptor.put(FloatType.class, "F");
        sootToDexTypeDescriptor.put(IntType.class, "I");
        sootToDexTypeDescriptor.put(LongType.class, "J");
        sootToDexTypeDescriptor.put(ShortType.class, "S");
        sootToDexTypeDescriptor.put(VoidType.class, "V");
    }
}

