/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

public class Base64 {
    private static final char[] alphabet;
    private static final byte[] codes;

    public static char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    public static byte[] decode(char[] data) {
        int tempLen = data.length;
        for (char element : data) {
            if (element <= '\u00ff' && codes[element] >= 0) continue;
            --tempLen;
        }
        int len = tempLen / 4 * 3;
        if (tempLen % 4 == 3) {
            len += 2;
        }
        if (tempLen % 4 == 2) {
            ++len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        for (char element : data) {
            int value;
            int n = value = element > '\u00ff' ? -1 : codes[element];
            if (value < 0) continue;
            accum <<= 6;
            accum |= value;
            if ((shift += 6) < 8) continue;
            out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
        }
        if (index != out.length) {
            throw new Error("Miscalculated data length (wrote " + index + " instead of " + out.length + ")");
        }
        return out;
    }

    static {
        int i;
        alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        codes = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base64.codes[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base64.codes[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64.codes[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            Base64.codes[i] = (byte)(52 + i - 48);
        }
        Base64.codes[43] = 62;
        Base64.codes[47] = 63;
    }
}

