/*
 * Decompiled with CFR 0.152.
 */
package soot.shimple;

import soot.Body;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.shimple.ShimpleFactory;
import soot.shimple.toolkits.graph.GlobalValueNumberer;
import soot.shimple.toolkits.graph.SimpleGlobalValueNumberer;
import soot.toolkits.graph.Block;
import soot.toolkits.graph.BlockGraph;
import soot.toolkits.graph.BlockGraphConverter;
import soot.toolkits.graph.CytronDominanceFrontier;
import soot.toolkits.graph.DominanceFrontier;
import soot.toolkits.graph.DominatorTree;
import soot.toolkits.graph.DominatorsFinder;
import soot.toolkits.graph.ExceptionalBlockGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;
import soot.toolkits.graph.HashReversibleGraph;
import soot.toolkits.graph.ReversibleGraph;
import soot.toolkits.graph.SimpleDominatorsFinder;
import soot.toolkits.graph.UnitGraph;

public class DefaultShimpleFactory
implements ShimpleFactory {
    protected final Body body;
    protected UnitGraph ug;
    protected BlockGraph bg;
    protected DominatorsFinder<Block> dFinder;
    protected DominatorTree<Block> dTree;
    protected DominanceFrontier<Block> dFrontier;
    protected GlobalValueNumberer gvn;
    protected ReversibleGraph<Block> rbg;
    protected DominatorsFinder<Block> rdFinder;
    protected DominatorTree<Block> rdTree;
    protected DominanceFrontier<Block> rdFrontier;

    public DefaultShimpleFactory(Body body) {
        this.body = body;
    }

    @Override
    public void clearCache() {
        this.ug = null;
        this.bg = null;
        this.dFinder = null;
        this.dTree = null;
        this.dFrontier = null;
        this.gvn = null;
        this.rbg = null;
        this.rdFinder = null;
        this.rdTree = null;
        this.rdFrontier = null;
    }

    public Body getBody() {
        Body body = this.body;
        if (body == null) {
            throw new RuntimeException("Assertion failed: Call setBody() first.");
        }
        return body;
    }

    @Override
    public ReversibleGraph<Block> getReverseBlockGraph() {
        ReversibleGraph<Block> rbg = this.rbg;
        if (rbg == null) {
            rbg = new HashReversibleGraph<Block>(this.getBlockGraph());
            rbg.reverse();
            this.rbg = rbg;
        }
        return rbg;
    }

    @Override
    public DominatorsFinder<Block> getReverseDominatorsFinder() {
        DominatorsFinder<Block> rdFinder = this.rdFinder;
        if (rdFinder == null) {
            this.rdFinder = rdFinder = new SimpleDominatorsFinder<Block>(this.getReverseBlockGraph());
        }
        return rdFinder;
    }

    @Override
    public DominatorTree<Block> getReverseDominatorTree() {
        DominatorTree<Block> rdTree = this.rdTree;
        if (rdTree == null) {
            this.rdTree = rdTree = new DominatorTree<Block>(this.getReverseDominatorsFinder());
        }
        return rdTree;
    }

    @Override
    public DominanceFrontier<Block> getReverseDominanceFrontier() {
        DominanceFrontier<Block> rdFrontier = this.rdFrontier;
        if (rdFrontier == null) {
            this.rdFrontier = rdFrontier = new CytronDominanceFrontier<Block>(this.getReverseDominatorTree());
        }
        return rdFrontier;
    }

    @Override
    public BlockGraph getBlockGraph() {
        BlockGraph bg = this.bg;
        if (bg == null) {
            bg = new ExceptionalBlockGraph((ExceptionalUnitGraph)this.getUnitGraph());
            BlockGraphConverter.addStartStopNodesTo(bg);
            this.bg = bg;
        }
        return bg;
    }

    @Override
    public UnitGraph getUnitGraph() {
        UnitGraph ug = this.ug;
        if (ug == null) {
            Body body = this.getBody();
            UnreachableCodeEliminator.v().transform(body);
            this.ug = ug = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body);
        }
        return ug;
    }

    @Override
    public DominatorsFinder<Block> getDominatorsFinder() {
        DominatorsFinder<Block> dFinder = this.dFinder;
        if (dFinder == null) {
            this.dFinder = dFinder = new SimpleDominatorsFinder<Block>(this.getBlockGraph());
        }
        return dFinder;
    }

    @Override
    public DominatorTree<Block> getDominatorTree() {
        DominatorTree<Block> dTree = this.dTree;
        if (dTree == null) {
            this.dTree = dTree = new DominatorTree<Block>(this.getDominatorsFinder());
        }
        return dTree;
    }

    @Override
    public DominanceFrontier<Block> getDominanceFrontier() {
        DominanceFrontier<Block> dFrontier = this.dFrontier;
        if (dFrontier == null) {
            this.dFrontier = dFrontier = new CytronDominanceFrontier<Block>(this.getDominatorTree());
        }
        return dFrontier;
    }

    @Override
    public GlobalValueNumberer getGlobalValueNumberer() {
        GlobalValueNumberer gvn = this.gvn;
        if (gvn == null) {
            this.gvn = gvn = new SimpleGlobalValueNumberer(this.getBlockGraph());
        }
        return gvn;
    }
}

