/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.validation;

import java.util.List;
import soot.Body;
import soot.SootMethod;
import soot.Unit;
import soot.baf.BafBody;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public enum InvokeArgumentValidator implements BodyValidator
{
    INSTANCE;


    public static InvokeArgumentValidator v() {
        return INSTANCE;
    }

    @Override
    public void validate(Body body, List<ValidationException> exceptions) {
        if (!(body instanceof BafBody)) {
            for (Unit unit : body.getUnits().getNonPatchingChain()) {
                InvokeExpr iinvExpr;
                SootMethod callee;
                Stmt s = (Stmt)unit;
                if (!s.containsInvokeExpr() || (callee = (iinvExpr = s.getInvokeExpr()).getMethod()) == null || iinvExpr.getArgCount() == callee.getParameterCount()) continue;
                exceptions.add(new ValidationException(s, "Invalid number of arguments"));
            }
        }
    }

    @Override
    public boolean isBasicValidator() {
        return true;
    }
}

