/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import heros.solver.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.toolkits.graph.DirectedGraph;
import soot.util.FastStack;

public class SCC<T> {
    private Set<T> gray = new HashSet<T>();
    private final LinkedList<T> finishedOrder = new LinkedList();
    private final List<List<T>> sccList = new ArrayList<List<T>>();

    public SCC(Iterator<T> it, DirectedGraph<T> g) {
        while (it.hasNext()) {
            T s = it.next();
            if (this.gray.contains(s)) continue;
            this.visitNode(g, s);
        }
        this.gray = new HashSet<T>();
        for (Object s : this.finishedOrder) {
            if (this.gray.contains(s)) continue;
            ArrayList scc = new ArrayList();
            this.visitRevNode(g, s, scc);
            this.sccList.add(scc);
        }
    }

    private void visitNode(DirectedGraph<T> g, T s) {
        this.gray.add(s);
        FastStack<Pair<Object, Iterator<T>>> stack = new FastStack<Pair<Object, Iterator<T>>>();
        stack.push(new Pair<T, Iterator<T>>(s, g.getSuccsOf(s).iterator()));
        block0: while (!stack.isEmpty()) {
            Pair p = (Pair)stack.peek();
            Iterator it = (Iterator)p.getO2();
            while (it.hasNext()) {
                Object succ = it.next();
                if (this.gray.contains(succ)) continue;
                this.gray.add(succ);
                stack.push(new Pair(succ, g.getSuccsOf(succ).iterator()));
                continue block0;
            }
            stack.pop();
            this.finishedOrder.addFirst(p.getO1());
        }
    }

    private void visitRevNode(DirectedGraph<T> g, T s, List<T> scc) {
        scc.add(s);
        this.gray.add(s);
        FastStack<Iterator<T>> stack = new FastStack<Iterator<T>>();
        stack.push(g.getPredsOf(s).iterator());
        block0: while (!stack.isEmpty()) {
            Iterator predsIt = (Iterator)stack.peek();
            while (predsIt.hasNext()) {
                Object pred = predsIt.next();
                if (this.gray.contains(pred)) continue;
                scc.add(pred);
                this.gray.add(pred);
                stack.push(g.getPredsOf(pred).iterator());
                continue block0;
            }
            stack.pop();
        }
    }

    public List<List<T>> getSccList() {
        return this.sccList;
    }

    public LinkedList<T> getFinishedOrder() {
        return this.finishedOrder;
    }
}

