/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.DirectedGraph;
import soot.util.dot.DotGraph;
import soot.util.dot.DotGraphNode;

public class PegCallGraphToDot {
    public static boolean isBrief = false;
    private static final Map<Object, String> listNodeName = new HashMap<Object, String>();
    public static boolean onepage = true;
    private static int nodecount = 0;

    public PegCallGraphToDot(DirectedGraph graph, boolean onepage, String name) {
        PegCallGraphToDot.onepage = onepage;
        PegCallGraphToDot.toDotFile(name, graph, "PegCallGraph");
    }

    public static void toDotFile(String methodname, DirectedGraph graph, String graphname) {
        int sequence = 0;
        nodecount = 0;
        Hashtable<Object, Integer> nodeindex = new Hashtable<Object, Integer>(graph.size());
        DotGraph canvas = new DotGraph(methodname);
        if (!onepage) {
            canvas.setPageSize(8.5, 11.0);
        }
        canvas.setNodeShape("box");
        canvas.setGraphLabel(graphname);
        for (Object node : graph) {
            if (!(node instanceof List)) continue;
            String listName = "list" + new Integer(sequence++).toString();
            String nodeName = PegCallGraphToDot.makeNodeName(PegCallGraphToDot.getNodeOrder(nodeindex, listName));
            listNodeName.put(node, listName);
        }
        for (Object node : graph) {
            String nodeName = null;
            nodeName = node instanceof List ? PegCallGraphToDot.makeNodeName(PegCallGraphToDot.getNodeOrder(nodeindex, listNodeName.get(node))) : PegCallGraphToDot.makeNodeName(PegCallGraphToDot.getNodeOrder(nodeindex, node));
            for (Object s : graph.getSuccsOf(node)) {
                String succName = null;
                if (s instanceof List) {
                    succName = PegCallGraphToDot.makeNodeName(PegCallGraphToDot.getNodeOrder(nodeindex, listNodeName.get(s)));
                } else {
                    Object succ = s;
                    succName = PegCallGraphToDot.makeNodeName(PegCallGraphToDot.getNodeOrder(nodeindex, succ));
                }
                canvas.drawEdge(nodeName, succName);
            }
        }
        if (!isBrief) {
            for (Object node : nodeindex.keySet()) {
                String nodename;
                DotGraphNode dotnode;
                if (node == null || (dotnode = canvas.getNode(nodename = PegCallGraphToDot.makeNodeName(PegCallGraphToDot.getNodeOrder(nodeindex, node)))) == null) continue;
                dotnode.setLabel(node.toString());
            }
        }
        canvas.plot("pecg.dot");
        listNodeName.clear();
    }

    private static int getNodeOrder(Hashtable<Object, Integer> nodeindex, Object node) {
        Integer index = nodeindex.get(node);
        if (index == null) {
            index = new Integer(nodecount++);
            nodeindex.put(node, index);
        }
        return index;
    }

    private static String makeNodeName(int index) {
        return "N" + index;
    }
}

