/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Singletons;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.StmtBody;
import soot.jimple.toolkits.scalar.Evaluator;
import soot.options.Options;

public class ConditionalBranchFolder
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(ConditionalBranchFolder.class);

    public ConditionalBranchFolder(Singletons.Global g) {
    }

    public static ConditionalBranchFolder v() {
        return G.v().soot_jimple_toolkits_scalar_ConditionalBranchFolder();
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        StmtBody stmtBody = (StmtBody)body;
        if (Options.v().verbose()) {
            logger.debug("[" + stmtBody.getMethod().getName() + "] Folding conditional branches...");
        }
        int numTrue = 0;
        int numFalse = 0;
        UnitPatchingChain units = stmtBody.getUnits();
        Iterator it = units.snapshotIterator();
        while (it.hasNext()) {
            IfStmt ifs;
            Value cond;
            Unit stmt = (Unit)it.next();
            if (!(stmt instanceof IfStmt) || (cond = Evaluator.getConstantValueOf((ifs = (IfStmt)stmt).getCondition())) == null) continue;
            assert (cond instanceof IntConstant);
            if (((IntConstant)cond).value == 1) {
                units.swapWith(stmt, Jimple.v().newGotoStmt(ifs.getTarget()));
                ++numTrue;
                continue;
            }
            assert (((IntConstant)cond).value == 0);
            units.remove(stmt);
            ++numFalse;
        }
        if (Options.v().verbose()) {
            logger.debug("[" + stmtBody.getMethod().getName() + "]     Folded " + numTrue + " true, " + numFalse + " conditional branches");
        }
    }
}

