/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.Local;
import soot.NullType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.IntConstant;
import soot.jimple.NewArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.shimple.PhiExpr;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class ConstantArrayAnalysis
extends ForwardFlowAnalysis<Unit, ArrayState> {
    private final Map<Local, Integer> localToInt = new HashMap<Local, Integer>();
    private final Map<Type, Integer> typeToInt = new HashMap<Type, Integer>();
    private final Map<Integer, Integer> sizeToInt = new HashMap<Integer, Integer>();
    private final Map<Integer, Type> rvTypeToInt = new HashMap<Integer, Type>();
    private final Map<Integer, Integer> rvSizeToInt = new HashMap<Integer, Integer>();
    private int size;
    private int typeSize;
    private int szSize;

    public ConstantArrayAnalysis(DirectedGraph<Unit> graph, Body b) {
        super(graph);
        for (Local l : b.getLocals()) {
            this.localToInt.put(l, this.size++);
        }
        for (Unit u : b.getUnits()) {
            int key;
            int sz;
            NewArrayExpr nae;
            if (!(u instanceof DefinitionStmt)) continue;
            Value rhs = ((DefinitionStmt)u).getRightOp();
            Type ty = rhs.getType();
            if (!this.typeToInt.containsKey(ty)) {
                int key2;
                ++this.typeSize;
                this.typeToInt.put(ty, key2);
                this.rvTypeToInt.put(key2, ty);
            }
            if (!(rhs instanceof NewArrayExpr) || !((nae = (NewArrayExpr)rhs).getSize() instanceof IntConstant) || this.sizeToInt.containsKey(sz = ((IntConstant)nae.getSize()).value)) continue;
            ++this.szSize;
            this.sizeToInt.put(sz, key);
            this.rvSizeToInt.put(key, sz);
        }
        this.doAnalysis();
    }

    @Override
    protected void flowThrough(ArrayState in, Unit d, ArrayState out) {
        out.active.clear();
        out.active.or(in.active);
        out.state = Arrays.copyOf(in.state, in.state.length);
        if (d instanceof DefinitionStmt) {
            Integer localRef;
            DefinitionStmt ds = (DefinitionStmt)d;
            Value rhs = ds.getRightOp();
            Value lhs = ds.getLeftOp();
            if (rhs instanceof NewArrayExpr) {
                Local l = (Local)lhs;
                int varRef = this.localToInt.get(l);
                out.active.set(varRef);
                Value naeSize = ((NewArrayExpr)rhs).getSize();
                if (naeSize instanceof IntConstant) {
                    int arraySize = ((IntConstant)naeSize).value;
                    out.state[varRef] = new ArrayTypesInternal();
                    out.state[varRef].sizeState.set(this.sizeToInt.get(arraySize));
                    out.state[varRef].typeState = new BitSet[arraySize];
                    out.state[varRef].mustAssign = new BitSet(arraySize);
                    for (int i = 0; i < arraySize; ++i) {
                        out.state[varRef].typeState[i] = new BitSet(this.typeSize);
                    }
                } else {
                    out.state[varRef] = null;
                }
            } else if (lhs instanceof ArrayRef) {
                ArrayRef ar = (ArrayRef)lhs;
                int localRef2 = this.localToInt.get((Local)ar.getBase());
                Value indexVal = ar.getIndex();
                if (!(indexVal instanceof IntConstant)) {
                    out.state[localRef2] = null;
                    out.active.set(localRef2);
                } else if (out.state[localRef2] != null) {
                    int index = ((IntConstant)indexVal).value;
                    assert (index < out.state[localRef2].typeState.length);
                    out.deepCloneLocalValueSlot(localRef2, index);
                    assert (out.state[localRef2].typeState[index] != null) : d;
                    out.state[localRef2].typeState[index].set(this.typeToInt.get(rhs.getType()));
                    out.state[localRef2].mustAssign.set(index);
                }
            } else if (lhs instanceof Local) {
                if (rhs instanceof NullConstant && lhs.getType() instanceof ArrayType) {
                    int varRef = this.localToInt.get((Local)lhs);
                    out.active.clear(varRef);
                    out.state[varRef] = null;
                } else if (rhs instanceof Local && in.state[this.localToInt.get((Local)rhs)] != null && in.active.get(this.localToInt.get((Local)rhs))) {
                    int lhsRef = this.localToInt.get((Local)lhs);
                    int rhsRef = this.localToInt.get((Local)rhs);
                    out.active.set(lhsRef);
                    out.state[lhsRef] = in.state[rhsRef];
                    out.state[rhsRef] = null;
                } else if (rhs instanceof PhiExpr) {
                    int argRef;
                    int i;
                    PhiExpr rPhi = (PhiExpr)rhs;
                    int lhsRef = this.localToInt.get((Local)lhs);
                    out.state[lhsRef] = null;
                    List<Value> phiValues = rPhi.getValues();
                    for (i = 0; i < phiValues.size(); ++i) {
                        argRef = this.localToInt.get((Local)phiValues.get(i));
                        if (!in.active.get(argRef)) continue;
                        out.active.set(lhsRef);
                        if (in.state[argRef] == null) {
                            out.state[lhsRef] = null;
                            break;
                        }
                        out.state[lhsRef] = out.state[lhsRef] == null ? in.state[argRef] : this.mergeTypeStates(in.state[argRef], out.state[lhsRef]);
                        out.state[argRef] = null;
                    }
                    while (i < phiValues.size()) {
                        argRef = this.localToInt.get((Local)phiValues.get(i));
                        out.state[argRef] = null;
                        ++i;
                    }
                } else {
                    int varRef = this.localToInt.get((Local)lhs);
                    out.active.set(varRef);
                    out.state[varRef] = null;
                }
            }
            for (ValueBox b : rhs.getUseBoxes()) {
                Integer localRef3;
                Value v = b.getValue();
                if (!(v instanceof Local) || (localRef3 = this.localToInt.get((Local)v)) == null) continue;
                int iLocalRef = localRef3;
                out.state[iLocalRef] = null;
                out.active.set(iLocalRef);
            }
            if (rhs instanceof Local && (localRef = this.localToInt.get((Local)rhs)) != null) {
                int iLocalRef = localRef;
                out.state[iLocalRef] = null;
                out.active.set(iLocalRef);
            }
        } else {
            for (ValueBox b : d.getUseBoxes()) {
                Integer localRef;
                Value v = b.getValue();
                if (!(v instanceof Local) || (localRef = this.localToInt.get((Local)v)) == null) continue;
                int iLocalRef = localRef;
                out.state[iLocalRef] = null;
                out.active.set(iLocalRef);
            }
        }
    }

    @Override
    protected ArrayState newInitialFlow() {
        return new ArrayState();
    }

    @Override
    protected void merge(ArrayState in1, ArrayState in2, ArrayState out) {
        out.active.clear();
        out.active.or(in1.active);
        out.active.or(in2.active);
        BitSet in2_excl = (BitSet)in2.active.clone();
        in2_excl.andNot(in1.active);
        int i = in1.active.nextSetBit(0);
        while (i >= 0) {
            out.state[i] = in1.state[i] == null ? null : (in2.active.get(i) ? (in2.state[i] == null ? null : this.mergeTypeStates(in1.state[i], in2.state[i])) : in1.state[i]);
            i = in1.active.nextSetBit(i + 1);
        }
        i = in2_excl.nextSetBit(0);
        while (i >= 0) {
            out.state[i] = in2.state[i];
            i = in2_excl.nextSetBit(i + 1);
        }
    }

    private ArrayTypesInternal mergeTypeStates(ArrayTypesInternal a1, ArrayTypesInternal a2) {
        int i;
        assert (a1 != null && a2 != null);
        ArrayTypesInternal toRet = new ArrayTypesInternal();
        toRet.sizeState.or(a1.sizeState);
        toRet.sizeState.or(a2.sizeState);
        int maxSize = Math.max(a1.typeState.length, a2.typeState.length);
        int commonSize = Math.min(a1.typeState.length, a2.typeState.length);
        toRet.mustAssign = new BitSet(maxSize);
        toRet.typeState = new BitSet[maxSize];
        for (i = 0; i < commonSize; ++i) {
            toRet.typeState[i] = new BitSet(this.typeSize);
            toRet.typeState[i].or(a1.typeState[i]);
            toRet.typeState[i].or(a2.typeState[i]);
            toRet.mustAssign.set(i, a1.mustAssign.get(i) && a2.mustAssign.get(i));
        }
        for (i = commonSize; i < maxSize; ++i) {
            if (a1.typeState.length > i) {
                toRet.typeState[i] = (BitSet)a1.typeState[i].clone();
                toRet.mustAssign.set(i, a1.mustAssign.get(i));
                continue;
            }
            toRet.mustAssign.set(i, a2.mustAssign.get(i));
            toRet.typeState[i] = (BitSet)a2.typeState[i].clone();
        }
        return toRet;
    }

    @Override
    protected void copy(ArrayState source, ArrayState dest) {
        dest.active = source.active;
        dest.state = source.state;
    }

    public boolean isConstantBefore(Stmt s, Local arrayLocal) {
        ArrayState flowResults = (ArrayState)this.getFlowBefore(s);
        int varRef = this.localToInt.get(arrayLocal);
        return flowResults.active.get(varRef) && flowResults.state[varRef] != null;
    }

    public ArrayTypes getArrayTypesBefore(Stmt s, Local arrayLocal) {
        if (!this.isConstantBefore(s, arrayLocal)) {
            return null;
        }
        ArrayTypes toRet = new ArrayTypes();
        int varRef = this.localToInt.get(arrayLocal);
        ArrayTypesInternal ati = ((ArrayState)this.getFlowBefore(s)).state[varRef];
        toRet.possibleSizes = new HashSet<Integer>();
        toRet.possibleTypes = new Set[ati.typeState.length];
        int i = ati.sizeState.nextSetBit(0);
        while (i >= 0) {
            toRet.possibleSizes.add(this.rvSizeToInt.get(i));
            i = ati.sizeState.nextSetBit(i + 1);
        }
        for (i = 0; i < toRet.possibleTypes.length; ++i) {
            toRet.possibleTypes[i] = new HashSet<Type>();
            int j = ati.typeState[i].nextSetBit(0);
            while (j >= 0) {
                toRet.possibleTypes[i].add(this.rvTypeToInt.get(j));
                j = ati.typeState[i].nextSetBit(j + 1);
            }
            if (ati.mustAssign.get(i)) continue;
            toRet.possibleTypes[i].add(NullType.v());
        }
        return toRet;
    }

    public class ArrayState {
        ArrayTypesInternal[] state;
        BitSet active;

        public ArrayState() {
            this.state = new ArrayTypesInternal[ConstantArrayAnalysis.this.size];
            this.active = new BitSet(ConstantArrayAnalysis.this.size);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ArrayState)) {
                return false;
            }
            ArrayState otherState = (ArrayState)obj;
            return this.active.equals(otherState.active) && Arrays.equals(this.state, otherState.state);
        }

        public int hashCode() {
            int hash = 3;
            hash = 73 * hash + Arrays.deepHashCode(this.state);
            hash = 73 * hash + Objects.hashCode(this.active);
            return hash;
        }

        public void deepCloneLocalValueSlot(int localRef, int index) {
            this.state[localRef] = (ArrayTypesInternal)this.state[localRef].clone();
            this.state[localRef].typeState[index] = (BitSet)this.state[localRef].typeState[index].clone();
        }
    }

    public static class ArrayTypes {
        public Set<Integer> possibleSizes;
        public Set<Type>[] possibleTypes;

        public String toString() {
            return "ArrayTypes [possibleSizes=" + this.possibleSizes + ", possibleTypes=" + Arrays.toString(this.possibleTypes) + "]";
        }
    }

    private class ArrayTypesInternal
    implements Cloneable {
        BitSet mustAssign;
        BitSet[] typeState;
        BitSet sizeState;

        private ArrayTypesInternal() {
            this.sizeState = new BitSet(ConstantArrayAnalysis.this.szSize);
        }

        public Object clone() {
            try {
                ArrayTypesInternal s = (ArrayTypesInternal)super.clone();
                s.sizeState = (BitSet)s.sizeState.clone();
                s.typeState = (BitSet[])s.typeState.clone();
                s.mustAssign = (BitSet)s.mustAssign.clone();
                return s;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ArrayTypesInternal)) {
                return false;
            }
            ArrayTypesInternal otherTypes = (ArrayTypesInternal)obj;
            return this.sizeState.equals(otherTypes.sizeState) && Arrays.equals(this.typeState, otherTypes.typeState) && this.mustAssign.equals(otherTypes.mustAssign);
        }

        public int hashCode() {
            int hash = 5;
            hash = 59 * hash + Objects.hashCode(this.mustAssign);
            hash = 59 * hash + Arrays.deepHashCode(this.typeState);
            hash = 59 * hash + Objects.hashCode(this.sizeState);
            return hash;
        }
    }
}

