/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.nullcheck;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import soot.Immediate;
import soot.Local;
import soot.RefLikeType;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;
import soot.jimple.internal.JCastExpr;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.BackwardFlowAnalysis;

public class NullnessAssumptionAnalysis
extends BackwardFlowAnalysis<Unit, AnalysisInfo> {
    protected static final Object BOTTOM = new Object(){

        public String toString() {
            return "bottom";
        }
    };
    protected static final Object NULL = new Object(){

        public String toString() {
            return "null";
        }
    };
    protected static final Object NON_NULL = new Object(){

        public String toString() {
            return "non-null";
        }
    };
    protected static final Object TOP = new Object(){

        public String toString() {
            return "top";
        }
    };

    public NullnessAssumptionAnalysis(UnitGraph graph) {
        super(graph);
        this.doAnalysis();
    }

    @Override
    protected void flowThrough(AnalysisInfo in, Unit unit, AnalysisInfo outValue) {
        DefinitionStmt defStmt;
        AnalysisInfo out = new AnalysisInfo(in);
        Stmt s = (Stmt)unit;
        if (s instanceof MonitorStmt) {
            out.put(((MonitorStmt)s).getOp(), NON_NULL);
        }
        if (s.containsArrayRef()) {
            this.handleArrayRef(s.getArrayRef(), out);
        }
        if (s.containsFieldRef()) {
            this.handleFieldRef(s.getFieldRef(), out);
        }
        if (s.containsInvokeExpr()) {
            this.handleInvokeExpr(s.getInvokeExpr(), out);
        }
        for (Map.Entry entry : out.entrySet()) {
            if (!this.isAlwaysNonNull((Value)entry.getKey())) continue;
            entry.setValue(NON_NULL);
        }
        if (s instanceof DefinitionStmt && (defStmt = (DefinitionStmt)s).getLeftOp().getType() instanceof RefLikeType) {
            this.handleRefTypeAssignment(defStmt, new AnalysisInfo(out), out);
        }
        Iterator outIter = out.keySet().iterator();
        while (outIter.hasNext()) {
            Value value = (Value)outIter.next();
            if (value instanceof Local) continue;
            outIter.remove();
        }
        this.copy(out, outValue);
    }

    protected boolean isAlwaysNonNull(Value v) {
        return false;
    }

    private void handleArrayRef(ArrayRef arrayRef, AnalysisInfo out) {
        out.put(arrayRef.getBase(), NON_NULL);
    }

    private void handleFieldRef(FieldRef fieldRef, AnalysisInfo out) {
        if (fieldRef instanceof InstanceFieldRef) {
            InstanceFieldRef instanceFieldRef = (InstanceFieldRef)fieldRef;
            out.put(instanceFieldRef.getBase(), NON_NULL);
        }
    }

    private void handleInvokeExpr(InvokeExpr invokeExpr, AnalysisInfo out) {
        if (invokeExpr instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)invokeExpr;
            out.put(instanceInvokeExpr.getBase(), NON_NULL);
        }
    }

    private void handleRefTypeAssignment(DefinitionStmt assignStmt, AnalysisInfo rhsInfo, AnalysisInfo out) {
        Value right = assignStmt.getRightOp();
        if (right instanceof JCastExpr) {
            right = ((JCastExpr)right).getOp();
        }
        rhsInfo.put(right, BOTTOM);
        out.put(assignStmt.getLeftOp(), rhsInfo.get(right));
    }

    @Override
    protected void copy(AnalysisInfo source, AnalysisInfo dest) {
        dest.clear();
        dest.putAll(source);
    }

    @Override
    protected AnalysisInfo entryInitialFlow() {
        return new AnalysisInfo();
    }

    @Override
    protected void merge(AnalysisInfo in1, AnalysisInfo in2, AnalysisInfo out) {
        HashSet values = new HashSet();
        values.addAll(in1.keySet());
        values.addAll(in2.keySet());
        out.clear();
        for (Value v : values) {
            HashSet<Object> leftAndRight = new HashSet<Object>();
            leftAndRight.add(in1.get(v));
            leftAndRight.add(in2.get(v));
            Object result = leftAndRight.contains(BOTTOM) ? BOTTOM : (leftAndRight.contains(NON_NULL) ? (leftAndRight.contains(NULL) ? BOTTOM : NON_NULL) : (leftAndRight.contains(NULL) ? NULL : BOTTOM));
            out.put(v, result);
        }
    }

    @Override
    protected AnalysisInfo newInitialFlow() {
        return new AnalysisInfo();
    }

    public boolean isAssumedNullBefore(Unit s, Immediate i) {
        return ((AnalysisInfo)this.getFlowBefore(s)).get(i) == NULL;
    }

    public boolean isAssumedNonNullBefore(Unit s, Immediate i) {
        return ((AnalysisInfo)this.getFlowBefore(s)).get(i) == NON_NULL;
    }

    protected static class AnalysisInfo
    extends HashMap<Value, Object> {
        public AnalysisInfo() {
        }

        public AnalysisInfo(Map<Value, Object> m) {
            super(m);
        }

        @Override
        public Object get(Object key) {
            Object object = super.get(key);
            if (object == null) {
                return BOTTOM;
            }
            return object;
        }
    }
}

