/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.ondemand;

import soot.SootField;
import soot.jimple.spark.ondemand.FieldCheckHeuristic;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.SparkField;

public class ManualFieldCheckHeuristic
implements FieldCheckHeuristic {
    private boolean allNotBothEnds = false;
    private static final String[] importantTypes = new String[]{"java.util.Vector", "java.util.Hashtable", "java.util.Hashtable$Entry", "java.util.Hashtable$Enumerator", "java.util.LinkedList", "java.util.LinkedList$Entry", "java.util.AbstractList$Itr", "java.util.Vector$1", "java.util.ArrayList"};
    private static final String[] notBothEndsTypes = new String[]{"java.util.Hashtable$Entry", "java.util.LinkedList$Entry"};

    @Override
    public boolean runNewPass() {
        if (!this.allNotBothEnds) {
            this.allNotBothEnds = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean validateMatchesForField(SparkField field) {
        if (field instanceof ArrayElement) {
            return true;
        }
        SootField sootField = (SootField)field;
        String fieldTypeStr = sootField.getDeclaringClass().getType().toString();
        for (String typeName : importantTypes) {
            if (!fieldTypeStr.equals(typeName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean validFromBothEnds(SparkField field) {
        if (this.allNotBothEnds) {
            return false;
        }
        if (field instanceof SootField) {
            SootField sootField = (SootField)field;
            String fieldTypeStr = sootField.getDeclaringClass().getType().toString();
            for (String typeName : notBothEndsTypes) {
                if (!fieldTypeStr.equals(typeName)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "Manual annotations";
    }
}

