/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import soot.IntType;
import soot.Type;
import soot.jimple.ArithmeticConstant;
import soot.jimple.ConstantSwitch;
import soot.jimple.NumericConstant;
import soot.util.Switch;

public class IntConstant
extends ArithmeticConstant {
    private static final long serialVersionUID = 8622167089453261784L;
    public final int value;
    private static final int MAX_CACHE = 128;
    private static final int MIN_CACHE = -127;
    private static final int ABS_MIN_CACHE = Math.abs(-127);
    private static final IntConstant[] CACHED = new IntConstant[128 + ABS_MIN_CACHE];

    protected IntConstant(int value) {
        this.value = value;
    }

    public static IntConstant v(int value) {
        if (value > -127 && value < 128) {
            int idx = value + ABS_MIN_CACHE;
            IntConstant c = CACHED[idx];
            if (c != null) {
                return c;
            }
            IntConstant.CACHED[idx] = c = new IntConstant(value);
            return c;
        }
        return new IntConstant(value);
    }

    public boolean equals(Object c) {
        return c instanceof IntConstant && ((IntConstant)c).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public NumericConstant add(NumericConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value + ((IntConstant)c).value);
    }

    @Override
    public NumericConstant subtract(NumericConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value - ((IntConstant)c).value);
    }

    @Override
    public NumericConstant multiply(NumericConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value * ((IntConstant)c).value);
    }

    @Override
    public NumericConstant divide(NumericConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value / ((IntConstant)c).value);
    }

    @Override
    public NumericConstant remainder(NumericConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value % ((IntConstant)c).value);
    }

    @Override
    public NumericConstant equalEqual(NumericConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value == ((IntConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant notEqual(NumericConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value != ((IntConstant)c).value ? 1 : 0);
    }

    @Override
    public boolean isLessThan(NumericConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return this.value < ((IntConstant)c).value;
    }

    @Override
    public NumericConstant lessThan(NumericConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value < ((IntConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant lessThanOrEqual(NumericConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value <= ((IntConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant greaterThan(NumericConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value > ((IntConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant greaterThanOrEqual(NumericConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value >= ((IntConstant)c).value ? 1 : 0);
    }

    @Override
    public NumericConstant negate() {
        return IntConstant.v(-this.value);
    }

    @Override
    public ArithmeticConstant and(ArithmeticConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value & ((IntConstant)c).value);
    }

    @Override
    public ArithmeticConstant or(ArithmeticConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value | ((IntConstant)c).value);
    }

    @Override
    public ArithmeticConstant xor(ArithmeticConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value ^ ((IntConstant)c).value);
    }

    @Override
    public ArithmeticConstant shiftLeft(ArithmeticConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value << ((IntConstant)c).value);
    }

    @Override
    public ArithmeticConstant shiftRight(ArithmeticConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value >> ((IntConstant)c).value);
    }

    @Override
    public ArithmeticConstant unsignedShiftRight(ArithmeticConstant c) {
        if (!(c instanceof IntConstant)) {
            throw new IllegalArgumentException("IntConstant expected");
        }
        return IntConstant.v(this.value >>> ((IntConstant)c).value);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public Type getType() {
        return IntType.v();
    }

    @Override
    public void apply(Switch sw) {
        ((ConstantSwitch)sw).caseIntConstant(this);
    }
}

