/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BooleanType;
import soot.G;
import soot.IntegerType;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.name.JunkNameGenerator;
import soot.jbco.name.NameGenerator;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;
import soot.jimple.FieldRef;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;

public class FieldRenamer
extends SceneTransformer
implements IJbcoTransform {
    private static final Logger logger = LoggerFactory.getLogger(FieldRenamer.class);
    public static final String name = "wjtp.jbco_fr";
    private static final String BOOLEAN_CLASS_NAME = Boolean.class.getName();
    private static final SootField[] EMPTY_ARRAY = new SootField[0];
    private final NameGenerator nameGenerator;
    private final Map<String, String> oldToNewFieldNames = new HashMap<String, String>();
    private final Map<SootClass, SootField> opaquePredicate1ByClass = new HashMap<SootClass, SootField>();
    private final Map<SootClass, SootField> opaquePredicate2ByClass = new HashMap<SootClass, SootField>();
    private SootField[][] opaquePairs = null;
    private final Set<String> skipFields = new HashSet<String>();
    public static int[] handedOutPairs = null;
    public static int[] handedOutRunPairs = null;
    private boolean renameFields = false;
    private final Object fieldNamesLock = new Object();

    public FieldRenamer(Singletons.Global global) {
        if (global == null) {
            throw new NullPointerException("Cannot instantiate FieldRenamer with null Singletons.Global");
        }
        this.nameGenerator = new JunkNameGenerator();
    }

    public static FieldRenamer v() {
        return G.v().soot_jbco_jimpleTransformations_FieldRenamer();
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String[] getDependencies() {
        return new String[]{name};
    }

    @Override
    public void outputSummary() {
        logger.info("Processed field mapping:");
        this.oldToNewFieldNames.forEach((oldName, newName) -> logger.info("{} -> {}", oldName, newName));
    }

    public boolean isRenameFields() {
        return this.renameFields;
    }

    public void setRenameFields(boolean renameFields) {
        this.renameFields = renameFields;
    }

    public void setSkipFields(Collection<String> fields) {
        if (!this.skipFields.isEmpty()) {
            this.skipFields.clear();
        }
        if (fields != null && !fields.isEmpty()) {
            this.skipFields.addAll(fields);
        }
    }

    public Set<String> getSkipFields() {
        return this.skipFields;
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        if (this.isVerbose()) {
            logger.info(this.renameFields ? "Transforming Field Names and Adding Opaque Predicates..." : "Adding Opaques...");
        }
        RefType booleanWrapperRefType = Scene.v().getRefType(BOOLEAN_CLASS_NAME);
        BodyBuilder.retrieveAllBodies();
        BodyBuilder.retrieveAllNames();
        for (SootClass applicationClass : Scene.v().getApplicationClasses()) {
            String className = applicationClass.getName();
            if (className.contains(".")) {
                className = className.substring(className.lastIndexOf(".") + 1);
            }
            this.oldToNewFieldNames.put(className, className);
            if (this.renameFields) {
                if (this.isVerbose()) {
                    logger.info("Class [{}]", (Object)applicationClass.getName());
                }
                for (SootField field : applicationClass.getFields()) {
                    if (Main.getWeight(phaseName, field.getSignature()) <= 0) continue;
                    this.renameField(applicationClass, field);
                    field.removeTag("SignatureTag");
                }
            }
            if (applicationClass.isInterface()) continue;
            String opaquePredicate = this.getOrAddNewName(null);
            Type type = Rand.getInt() % 2 == 0 ? BooleanType.v() : booleanWrapperRefType;
            SootField opaquePredicateField = Scene.v().makeSootField(opaquePredicate, type, 9);
            this.renameField(applicationClass, opaquePredicateField);
            this.opaquePredicate1ByClass.put(applicationClass, opaquePredicateField);
            applicationClass.addField(opaquePredicateField);
            this.setBooleanTo(applicationClass, opaquePredicateField, true);
            opaquePredicate = this.getOrAddNewName(null);
            type = type == BooleanType.v() ? booleanWrapperRefType : BooleanType.v();
            opaquePredicateField = Scene.v().makeSootField(opaquePredicate, type, 9);
            this.renameField(applicationClass, opaquePredicateField);
            this.opaquePredicate2ByClass.put(applicationClass, opaquePredicateField);
            applicationClass.addField(opaquePredicateField);
            if (type != booleanWrapperRefType) continue;
            this.setBooleanTo(applicationClass, opaquePredicateField, false);
        }
        this.buildOpaquePairings();
        if (!this.renameFields) {
            return;
        }
        if (this.isVerbose()) {
            logger.info("Updating field references in bytecode");
        }
        for (SootClass applicationClass : Scene.v().getApplicationClasses()) {
            for (SootMethod method : applicationClass.getMethods()) {
                if (!method.isConcrete()) continue;
                if (!method.hasActiveBody()) {
                    method.retrieveActiveBody();
                }
                for (Unit unit : method.getActiveBody().getUnits()) {
                    for (ValueBox box : unit.getUseAndDefBoxes()) {
                        FieldRef fieldRef;
                        SootFieldRef sootFieldRef;
                        Value value = box.getValue();
                        if (!(value instanceof FieldRef) || (sootFieldRef = (fieldRef = (FieldRef)value).getFieldRef()).declaringClass().isLibraryClass()) continue;
                        String oldName = sootFieldRef.name();
                        String fullyQualifiedName = sootFieldRef.declaringClass().getName() + '.' + oldName;
                        if (this.skipFields.contains(fullyQualifiedName)) continue;
                        String newName = this.oldToNewFieldNames.get(oldName);
                        if (!this.oldToNewFieldNames.containsKey(oldName)) {
                            newName = oldName;
                        } else {
                            if (newName == null) {
                                throw new IllegalStateException("Found incorrect field mapping [" + fullyQualifiedName + "] -> [null].");
                            }
                            if (newName.equals(oldName)) {
                                logger.warn("The new name of the field \"{}\" is equal to the old one. Check if it is a mistake.", (Object)fullyQualifiedName);
                            }
                        }
                        sootFieldRef = Scene.v().makeFieldRef(sootFieldRef.declaringClass(), newName, sootFieldRef.type(), sootFieldRef.isStatic());
                        fieldRef.setFieldRef(sootFieldRef);
                        try {
                            sootFieldRef.resolve();
                        }
                        catch (Exception exception) {
                            logger.error("Cannot rename field \"" + oldName + "\" to \"" + newName + "\" due to error.", exception);
                            logger.info("Fields of {}: {}", (Object)sootFieldRef.declaringClass().getName(), (Object)sootFieldRef.declaringClass().getFields());
                            throw new RuntimeException(exception);
                        }
                    }
                }
            }
        }
    }

    protected void setBooleanTo(SootClass sootClass, SootField field, boolean value) {
        Body body;
        boolean addStaticInitializer;
        if (!value && field.getType() instanceof IntegerType && Rand.getInt() % 2 > 0) {
            return;
        }
        RefType booleanWrapperRefType = Scene.v().getRefType(BOOLEAN_CLASS_NAME);
        boolean bl = addStaticInitializer = !sootClass.declaresMethodByName("<clinit>");
        if (addStaticInitializer) {
            SootMethod staticInitializerMethod = Scene.v().makeSootMethod("<clinit>", Collections.emptyList(), VoidType.v(), 8);
            sootClass.addMethod(staticInitializerMethod);
            body = Jimple.v().newBody(staticInitializerMethod);
            staticInitializerMethod.setActiveBody(body);
        } else {
            body = sootClass.getMethodByName("<clinit>").getActiveBody();
        }
        UnitPatchingChain units = body.getUnits();
        if (field.getType() instanceof IntegerType) {
            units.addFirst(Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(field.makeRef()), IntConstant.v(value ? 1 : 0)));
        } else {
            Local bool = Jimple.v().newLocal("boolLcl", booleanWrapperRefType);
            body.getLocals().add(bool);
            SootMethod booleanWrapperConstructor = booleanWrapperRefType.getSootClass().getMethod("void <init>(boolean)");
            units.addFirst(Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(field.makeRef()), bool));
            units.addFirst(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(bool, booleanWrapperConstructor.makeRef(), (Value)IntConstant.v(value ? 1 : 0))));
            units.addFirst(Jimple.v().newAssignStmt(bool, Jimple.v().newNewExpr(booleanWrapperRefType)));
        }
        if (addStaticInitializer) {
            units.addLast(Jimple.v().newReturnVoidStmt());
        }
    }

    protected void renameField(SootClass sootClass, SootField field) {
        String fullyQualifiedName = sootClass.getName() + "." + field.getName();
        String newName = this.getOrAddNewName(field.getName());
        if (this.isVerbose()) {
            logger.info("Changing {} to {}", (Object)fullyQualifiedName, (Object)newName);
        }
        field.setName(newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOrAddNewName(String originalName) {
        int size = 5;
        int tries = 0;
        String newName = "";
        if (originalName != null && this.oldToNewFieldNames.containsKey(newName = originalName)) {
            return this.oldToNewFieldNames.get(originalName);
        }
        Object object = this.fieldNamesLock;
        synchronized (object) {
            if (this.oldToNewFieldNames.containsKey(newName)) {
                return this.oldToNewFieldNames.get(newName);
            }
            while (newName.length() < 21845) {
                String key;
                newName = this.nameGenerator.generateName(size);
                String string = key = originalName == null ? newName : originalName;
                if (!(this.oldToNewFieldNames.containsKey(key) || this.oldToNewFieldNames.containsValue(newName) || BodyBuilder.nameList.contains(newName))) {
                    this.oldToNewFieldNames.put(key, newName);
                    BodyBuilder.nameList.add(newName);
                    return newName;
                }
                if (tries++ <= size) continue;
                ++size;
                tries = 0;
            }
        }
        throw new IllegalStateException("Cannot generate unique package name part: too long for JVM.");
    }

    public SootField[] getRandomOpaques() {
        int index;
        if (handedOutPairs == null) {
            handedOutPairs = new int[this.opaquePairs.length];
        }
        int lowValue = 99999;
        ArrayList<Integer> available = new ArrayList<Integer>();
        for (int element : handedOutPairs) {
            if (lowValue <= element) continue;
            lowValue = element;
        }
        for (int i = 0; i < handedOutPairs.length; ++i) {
            if (handedOutPairs[i] != lowValue) continue;
            available.add(i);
        }
        int n = index = ((Integer)available.get(Rand.getInt(available.size()))).intValue();
        handedOutPairs[n] = handedOutPairs[n] + 1;
        return this.opaquePairs[index];
    }

    public int getRandomOpaquesForRunnable() {
        if (handedOutRunPairs == null) {
            handedOutRunPairs = new int[this.opaquePairs.length];
        }
        int lowValue = 99999;
        ArrayList<Integer> available = new ArrayList<Integer>();
        for (int element : handedOutRunPairs) {
            if (lowValue <= element) continue;
            lowValue = element;
        }
        if (lowValue > 2) {
            return -1;
        }
        for (int i = 0; i < handedOutRunPairs.length; ++i) {
            if (handedOutRunPairs[i] != lowValue) continue;
            available.add(i);
        }
        return (Integer)available.get(Rand.getInt(available.size()));
    }

    public static void updateOpaqueRunnableCount(int i) {
        int n = i;
        handedOutRunPairs[n] = handedOutRunPairs[n] + 1;
    }

    private void buildOpaquePairings() {
        int i;
        SootField[] fields1 = this.opaquePredicate1ByClass.values().toArray(EMPTY_ARRAY);
        SootField[] fields2 = this.opaquePredicate2ByClass.values().toArray(EMPTY_ARRAY);
        int length = fields1.length;
        for (i = 0; i < fields1.length * 2 && fields1.length > 1; ++i) {
            FieldRenamer.swap(fields1);
            FieldRenamer.swap(fields2);
        }
        this.opaquePairs = new SootField[length][2];
        for (i = 0; i < length; ++i) {
            this.opaquePairs[i] = new SootField[]{fields1[i], fields2[i]};
        }
    }

    private static <T> void swap(T[] x) {
        int a = Rand.getInt(x.length);
        int b = Rand.getInt(x.length);
        while (a == b) {
            b = Rand.getInt(x.length);
        }
        T t = x[a];
        x[a] = x[b];
        x[b] = t;
    }
}

