/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import soot.Body;
import soot.FastHierarchy;
import soot.Hierarchy;
import soot.Local;
import soot.PrimType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.jimpleTransformations.ClassRenamer;
import soot.jbco.jimpleTransformations.MethodRenamer;
import soot.jbco.util.BodyBuilder;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.ThisRef;
import soot.util.Chain;

public class BuildIntermediateAppClasses
extends SceneTransformer
implements IJbcoTransform {
    private static int newclasses = 0;
    private static int newmethods = 0;
    public static String[] dependancies = new String[]{"wjtp.jbco_bapibm"};
    public static String name = "wjtp.jbco_bapibm";

    @Override
    public void outputSummary() {
        out.println("New buffer classes created: " + newclasses);
        out.println("New buffer class methods created: " + newmethods);
    }

    @Override
    public String[] getDependencies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        if (output) {
            out.println("Building Intermediate Classes...");
        }
        BodyBuilder.retrieveAllBodies();
        Iterator<SootClass> it = Scene.v().getApplicationClasses().snapshotIterator();
        while (it.hasNext()) {
            ArrayList<SootMethod> initMethodsToRewrite = new ArrayList<SootMethod>();
            HashMap methodsToAdd = new HashMap();
            SootClass sc = it.next();
            SootClass originalSuperclass = sc.getSuperclass();
            if (output) {
                out.println("Processing " + sc.getName() + " with super " + originalSuperclass.getName());
            }
            Iterator<SootMethod> methodIterator = sc.methodIterator();
            while (methodIterator.hasNext()) {
                String subSig;
                SootMethod method;
                block20: {
                    method = methodIterator.next();
                    if (!method.isConcrete()) continue;
                    try {
                        method.getActiveBody();
                    }
                    catch (Exception e) {
                        if (method.retrieveActiveBody() != null) break block20;
                        throw new RuntimeException(method.getSignature() + " has no body. This was not expected dude.");
                    }
                }
                if ((subSig = method.getSubSignature()).equals("void main(java.lang.String[])") && method.isPublic() && method.isStatic()) continue;
                if (subSig.indexOf("init>(") > 0) {
                    if (!subSig.startsWith("void <init>(")) continue;
                    initMethodsToRewrite.add(method);
                    continue;
                }
                Scene.v().releaseActiveHierarchy();
                this.findAccessibleInSuperClassesBySubSig(sc, subSig).ifPresent(m -> methodsToAdd.put(subSig, m));
            }
            if (methodsToAdd.size() <= 0) continue;
            String fullName = ClassRenamer.v().getOrAddNewName(ClassRenamer.getPackageName(sc.getName()), null);
            if (output) {
                out.println("\tBuilding " + fullName);
            }
            SootClass mediatingClass = new SootClass(fullName, sc.getModifiers() & 0xFFFFFFEF);
            Main.IntermediateAppClasses.add(mediatingClass);
            mediatingClass.setSuperclass(originalSuperclass);
            Scene.v().addClass(mediatingClass);
            mediatingClass.setApplicationClass();
            mediatingClass.setInScene(true);
            ThisRef thisRef = new ThisRef(mediatingClass.getType());
            for (String subSig : methodsToAdd.keySet()) {
                SootMethod originalSuperclassMethod = (SootMethod)methodsToAdd.get(subSig);
                List<Type> paramTypes = originalSuperclassMethod.getParameterTypes();
                Type returnType = originalSuperclassMethod.getReturnType();
                List<SootClass> exceptions = originalSuperclassMethod.getExceptions();
                int modifiers = originalSuperclassMethod.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF;
                String newMethodName = MethodRenamer.v().getNewName();
                SootMethod newMethod = Scene.v().makeSootMethod(newMethodName, paramTypes, returnType, modifiers, exceptions);
                mediatingClass.addMethod(newMethod);
                JimpleBody body = Jimple.v().newBody(newMethod);
                newMethod.setActiveBody(body);
                Chain<Local> locals = body.getLocals();
                UnitPatchingChain units = body.getUnits();
                BodyBuilder.buildThisLocal(units, thisRef, locals);
                BodyBuilder.buildParameterLocals(units, locals, paramTypes);
                if (returnType instanceof VoidType) {
                    units.add(Jimple.v().newReturnVoidStmt());
                } else if (returnType instanceof PrimType) {
                    units.add(Jimple.v().newReturnStmt(IntConstant.v(0)));
                } else {
                    units.add(Jimple.v().newReturnStmt(NullConstant.v()));
                }
                ++newmethods;
                newMethod = Scene.v().makeSootMethod(originalSuperclassMethod.getName(), paramTypes, returnType, modifiers, exceptions);
                mediatingClass.addMethod(newMethod);
                JimpleBody body2 = Jimple.v().newBody(newMethod);
                newMethod.setActiveBody(body2);
                Chain<Local> locals2 = body2.getLocals();
                UnitPatchingChain units2 = body2.getUnits();
                Local ths = BodyBuilder.buildThisLocal(units2, thisRef, locals2);
                List<Local> args = BodyBuilder.buildParameterLocals(units2, locals2, paramTypes);
                SootMethodRef superclassMethodRef = originalSuperclassMethod.makeRef();
                if (returnType instanceof VoidType) {
                    units2.add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(ths, superclassMethodRef, args)));
                    units2.add(Jimple.v().newReturnVoidStmt());
                } else {
                    Local loc = Jimple.v().newLocal("retValue", returnType);
                    body2.getLocals().add(loc);
                    units2.add(Jimple.v().newAssignStmt(loc, Jimple.v().newSpecialInvokeExpr(ths, superclassMethodRef, args)));
                    units2.add(Jimple.v().newReturnStmt(loc));
                }
                ++newmethods;
            }
            sc.setSuperclass(mediatingClass);
            int i = initMethodsToRewrite.size();
            while (i-- > 0) {
                SootMethod im = (SootMethod)initMethodsToRewrite.remove(i);
                Body b = im.getActiveBody();
                Local thisLocal = b.getThisLocal();
                Iterator uIt = b.getUnits().snapshotIterator();
                while (uIt.hasNext()) {
                    for (ValueBox valueBox : ((Unit)uIt.next()).getUseBoxes()) {
                        SootMethod newSuperInit;
                        Value v = valueBox.getValue();
                        if (!(v instanceof SpecialInvokeExpr)) continue;
                        SpecialInvokeExpr sie = (SpecialInvokeExpr)v;
                        SootMethodRef smr = sie.getMethodRef();
                        if (!sie.getBase().equivTo(thisLocal) || !smr.declaringClass().getName().equals(originalSuperclass.getName()) || !smr.getSubSignature().getString().startsWith("void <init>")) continue;
                        if (!mediatingClass.declaresMethod("<init>", smr.parameterTypes())) {
                            List<Type> paramTypes = smr.parameterTypes();
                            newSuperInit = Scene.v().makeSootMethod("<init>", paramTypes, smr.returnType());
                            mediatingClass.addMethod(newSuperInit);
                            JimpleBody body = Jimple.v().newBody(newSuperInit);
                            newSuperInit.setActiveBody(body);
                            UnitPatchingChain initUnits = body.getUnits();
                            Chain<Local> locals = body.getLocals();
                            Local ths = BodyBuilder.buildThisLocal(initUnits, thisRef, locals);
                            List<Local> args = BodyBuilder.buildParameterLocals(initUnits, locals, paramTypes);
                            initUnits.add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(ths, smr, args)));
                            initUnits.add(Jimple.v().newReturnVoidStmt());
                        } else {
                            newSuperInit = mediatingClass.getMethod("<init>", smr.parameterTypes());
                        }
                        sie.setMethodRef(newSuperInit.makeRef());
                    }
                }
            }
        }
        newclasses = Main.IntermediateAppClasses.size();
        Scene.v().releaseActiveHierarchy();
        Scene.v().getActiveHierarchy();
        Scene.v().setFastHierarchy(new FastHierarchy());
    }

    private Optional<SootMethod> findAccessibleInSuperClassesBySubSig(SootClass base, String subSig) {
        Hierarchy hierarchy = Scene.v().getActiveHierarchy();
        for (SootClass superClass : hierarchy.getSuperclassesOfIncluding(base.getSuperclass())) {
            SootMethod method;
            if (!superClass.isLibraryClass() || !superClass.declaresMethod(subSig) || !hierarchy.isVisible(base, method = superClass.getMethod(subSig))) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }
}

