/*
 * Decompiled with CFR 0.152.
 */
package soot.javaToJimple;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LocalGenerator;
import soot.LongType;
import soot.RefLikeType;
import soot.ShortType;
import soot.Type;
import soot.UnknownType;
import soot.VoidType;
import soot.jimple.Jimple;
import soot.jimple.toolkits.typing.fast.Integer127Type;
import soot.jimple.toolkits.typing.fast.Integer1Type;
import soot.jimple.toolkits.typing.fast.Integer32767Type;
import soot.util.Chain;

public class DefaultLocalGenerator
extends LocalGenerator {
    protected final Chain<Local> locals;
    protected Set<String> names;
    protected long expectedModCount;
    private int tempInt = -1;
    private int tempVoid = -1;
    private int tempBoolean = -1;
    private int tempLong = -1;
    private int tempDouble = -1;
    private int tempFloat = -1;
    private int tempRefLikeType = -1;
    private int tempByte = -1;
    private int tempShort = -1;
    private int tempChar = -1;
    private int tempUnknownType = -1;

    public DefaultLocalGenerator(Body b) {
        this.locals = b.getLocals();
        this.names = null;
        this.expectedModCount = -1L;
    }

    @Override
    public Local generateLocal(Type type) {
        String name;
        Supplier<String> nameGen;
        if (type instanceof IntType || type instanceof Integer1Type || type instanceof Integer127Type || type instanceof Integer32767Type) {
            nameGen = this::nextIntName;
        } else if (type instanceof ByteType) {
            nameGen = this::nextByteName;
        } else if (type instanceof ShortType) {
            nameGen = this::nextShortName;
        } else if (type instanceof BooleanType) {
            nameGen = this::nextBooleanName;
        } else if (type instanceof VoidType) {
            nameGen = this::nextVoidName;
        } else if (type instanceof CharType) {
            nameGen = this::nextCharName;
        } else if (type instanceof DoubleType) {
            nameGen = this::nextDoubleName;
        } else if (type instanceof FloatType) {
            nameGen = this::nextFloatName;
        } else if (type instanceof LongType) {
            nameGen = this::nextLongName;
        } else if (type instanceof RefLikeType) {
            nameGen = this::nextRefLikeTypeName;
        } else if (type instanceof UnknownType) {
            nameGen = this::nextUnknownTypeName;
        } else {
            throw new RuntimeException(String.format("Unhandled Type %s of Local variable to Generate - Not Implemented", type.getClass().getName()));
        }
        Set<String> localNames = this.names;
        Chain<Local> locs = this.locals;
        long modCount = locs.getModificationCount();
        if (this.expectedModCount != modCount) {
            this.expectedModCount = modCount;
            this.names = localNames = new HashSet<String>(locs.size());
            for (Local l : locs) {
                localNames.add(l.getName());
            }
        }
        assert (localNames != null);
        while (localNames.contains(name = nameGen.get())) {
        }
        return this.createLocal(name, type);
    }

    private String nextIntName() {
        return "$i" + ++this.tempInt;
    }

    private String nextCharName() {
        return "$c" + ++this.tempChar;
    }

    private String nextVoidName() {
        return "$v" + ++this.tempVoid;
    }

    private String nextByteName() {
        return "$b" + ++this.tempByte;
    }

    private String nextShortName() {
        return "$s" + ++this.tempShort;
    }

    private String nextBooleanName() {
        return "$z" + ++this.tempBoolean;
    }

    private String nextDoubleName() {
        return "$d" + ++this.tempDouble;
    }

    private String nextFloatName() {
        return "$f" + ++this.tempFloat;
    }

    private String nextLongName() {
        return "$l" + ++this.tempLong;
    }

    private String nextRefLikeTypeName() {
        return "$r" + ++this.tempRefLikeType;
    }

    private String nextUnknownTypeName() {
        return "$u" + ++this.tempUnknownType;
    }

    protected Local createLocal(String name, Type sootType) {
        assert (this.expectedModCount == this.locals.getModificationCount());
        assert (!this.names.contains(name));
        Local sootLocal = Jimple.v().newLocal(name, sootType);
        this.locals.add(sootLocal);
        ++this.expectedModCount;
        this.names.add(name);
        assert (this.expectedModCount == this.locals.getModificationCount());
        assert (this.names.contains(name));
        return sootLocal;
    }
}

