/*
 * Decompiled with CFR 0.152.
 */
package soot.grimp.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import soot.RefType;
import soot.SootMethodRef;
import soot.Type;
import soot.UnitPrinter;
import soot.Value;
import soot.grimp.Grimp;
import soot.grimp.GrimpValueSwitch;
import soot.grimp.NewInvokeExpr;
import soot.grimp.Precedence;
import soot.grimp.internal.ExprBox;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.util.Switch;

public class GNewInvokeExpr
extends AbstractInvokeExpr
implements NewInvokeExpr,
Precedence {
    protected RefType type;

    public GNewInvokeExpr(RefType type, SootMethodRef methodRef, List<? extends Value> args) {
        super(methodRef, new ExprBox[args.size()]);
        if (methodRef != null && methodRef.isStatic()) {
            throw new RuntimeException("wrong static-ness");
        }
        this.type = type;
        Grimp grmp = Grimp.v();
        ListIterator<? extends Value> it = args.listIterator();
        while (it.hasNext()) {
            Value v = it.next();
            this.argBoxes[it.previousIndex()] = grmp.newExprBox(v);
        }
    }

    @Override
    public RefType getBaseType() {
        return this.type;
    }

    @Override
    public void setBaseType(RefType type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public int getPrecedence() {
        return 850;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("new ");
        buf.append(this.type.toString()).append('(');
        if (this.argBoxes != null) {
            int e = this.argBoxes.length;
            for (int i = 0; i < e; ++i) {
                if (i != 0) {
                    buf.append(", ");
                }
                buf.append(this.argBoxes[i].getValue().toString());
            }
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("new ");
        up.type(this.type);
        up.literal("(");
        if (this.argBoxes != null) {
            int e = this.argBoxes.length;
            for (int i = 0; i < e; ++i) {
                if (i != 0) {
                    up.literal(", ");
                }
                this.argBoxes[i].toString(up);
            }
        }
        up.literal(")");
    }

    @Override
    public void apply(Switch sw) {
        ((GrimpValueSwitch)sw).caseNewInvokeExpr(this);
    }

    @Override
    public Object clone() {
        int count = this.getArgCount();
        ArrayList<Value> clonedArgs = new ArrayList<Value>(count);
        for (int i = 0; i < count; ++i) {
            clonedArgs.add(Grimp.cloneIfNecessary(this.getArg(i)));
        }
        return new GNewInvokeExpr(this.getBaseType(), this.methodRef, clonedArgs);
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof GNewInvokeExpr) {
            GNewInvokeExpr ie = (GNewInvokeExpr)o;
            if ((this.argBoxes == null ? 0 : this.argBoxes.length) != (ie.argBoxes == null ? 0 : ie.argBoxes.length) || !this.getMethod().equals(ie.getMethod()) || !this.type.equals(ie.type)) {
                return false;
            }
            if (this.argBoxes != null) {
                int e = this.argBoxes.length;
                for (int i = 0; i < e; ++i) {
                    if (this.argBoxes[i].getValue().equivTo(ie.argBoxes[i].getValue())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.getMethod().equivHashCode();
    }
}

