/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.G;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.dexpler.DalvikThrowAnalysis;
import soot.jimple.Jimple;
import soot.options.Options;
import soot.toolkits.exceptions.TrapTransformer;
import soot.toolkits.graph.ExceptionalGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;

public class TrapMinimizer
extends TrapTransformer {
    public TrapMinimizer(Singletons.Global g) {
    }

    public static TrapMinimizer v() {
        return G.v().soot_dexpler_TrapMinimizer();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        if (b.getTraps().size() == 0) {
            return;
        }
        ExceptionalUnitGraph eug = ExceptionalUnitGraphFactory.createExceptionalUnitGraph(b, DalvikThrowAnalysis.v(), Options.v().omit_excepting_unit_edges());
        Set<Unit> unitsWithMonitor = this.getUnitsWithMonitor(eug);
        HashMap replaceTrapBy = new HashMap(b.getTraps().size());
        boolean updateTrap = false;
        for (Trap tr : b.getTraps()) {
            ArrayList<Trap> newTraps = new ArrayList<Trap>();
            Unit firstTrapStmt = tr.getBeginUnit();
            boolean goesToHandler = false;
            updateTrap = false;
            Unit u = tr.getBeginUnit();
            while (u != tr.getEndUnit()) {
                Trap t;
                if (goesToHandler) {
                    goesToHandler = false;
                } else {
                    firstTrapStmt = u;
                }
                if (tr.getException().getName().equals("java.lang.Throwable") && unitsWithMonitor.contains(u)) {
                    goesToHandler = true;
                }
                if (!goesToHandler && DalvikThrowAnalysis.v().mightThrow(u).catchableAs(tr.getException().getType())) {
                    for (ExceptionalGraph.ExceptionDest exceptionDest : eug.getExceptionDests(u)) {
                        if (exceptionDest.getTrap() != tr) continue;
                        goesToHandler = true;
                        break;
                    }
                }
                if (!goesToHandler) {
                    updateTrap = true;
                    if (firstTrapStmt != u) {
                        t = Jimple.v().newTrap(tr.getException(), firstTrapStmt, u, tr.getHandlerUnit());
                        newTraps.add(t);
                    }
                } else if (b.getUnits().getSuccOf(u) == tr.getEndUnit() && updateTrap) {
                    t = Jimple.v().newTrap(tr.getException(), firstTrapStmt, tr.getEndUnit(), tr.getHandlerUnit());
                    newTraps.add(t);
                }
                u = b.getUnits().getSuccOf(u);
            }
            if (!updateTrap) continue;
            replaceTrapBy.put(tr, newTraps);
        }
        for (Trap k : replaceTrapBy.keySet()) {
            b.getTraps().insertAfter((List)replaceTrapBy.get(k), k);
            b.getTraps().remove(k);
        }
    }
}

