/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.dexpler.DexTransformer;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;

public class DexReturnInliner
extends DexTransformer {
    public static DexReturnInliner v() {
        return new DexReturnInliner();
    }

    private boolean isInstanceofReturn(Unit u) {
        return u instanceof ReturnStmt || u instanceof ReturnVoidStmt;
    }

    private boolean isInstanceofFlowChange(Unit u) {
        return u instanceof GotoStmt || this.isInstanceofReturn(u);
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        Set<Unit> duplicateIfTargets = this.getFallThroughReturns(body);
        Iterator it = body.getUnits().snapshotIterator();
        boolean mayBeMore = false;
        Unit last = null;
        do {
            mayBeMore = false;
            while (it.hasNext()) {
                Unit u = (Unit)it.next();
                if (u instanceof GotoStmt) {
                    GotoStmt gtStmt = (GotoStmt)u;
                    if (this.isInstanceofReturn(gtStmt.getTarget())) {
                        Stmt stmt = (Stmt)gtStmt.getTarget().clone();
                        for (Trap t : body.getTraps()) {
                            for (UnitBox ubox : t.getUnitBoxes()) {
                                if (ubox.getUnit() != u) continue;
                                ubox.setUnit(stmt);
                            }
                        }
                        while (!u.getBoxesPointingToThis().isEmpty()) {
                            u.getBoxesPointingToThis().get(0).setUnit(stmt);
                        }
                        stmt.addAllTagsOf(u);
                        body.getUnits().swapWith(u, stmt);
                        mayBeMore = true;
                    }
                } else if (u instanceof IfStmt) {
                    IfStmt ifstmt = (IfStmt)u;
                    Stmt t = ifstmt.getTarget();
                    if (this.isInstanceofReturn(t)) {
                        if (duplicateIfTargets == null) {
                            duplicateIfTargets = new HashSet<Unit>();
                        }
                        if (!duplicateIfTargets.add(t)) {
                            Unit newTarget = (Unit)t.clone();
                            body.getUnits().addLast(newTarget);
                            ifstmt.setTarget(newTarget);
                        }
                    }
                } else if (this.isInstanceofReturn(u) && last != null) {
                    u.removeAllTags();
                    u.addAllTagsOf(last);
                }
                last = u;
            }
        } while (mayBeMore);
    }

    private Set<Unit> getFallThroughReturns(Body body) {
        HashSet<Unit> fallThroughReturns = null;
        Unit lastUnit = null;
        for (Unit u : body.getUnits()) {
            if (lastUnit != null && this.isInstanceofReturn(u) && !this.isInstanceofFlowChange(lastUnit)) {
                if (fallThroughReturns == null) {
                    fallThroughReturns = new HashSet<Unit>();
                }
                fallThroughReturns.add(u);
            }
            lastUnit = u;
        }
        return fallThroughReturns;
    }
}

