/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.finders;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.G;
import soot.Local;
import soot.Singletons;
import soot.Value;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.RetriggerAnalysisException;
import soot.dava.internal.SET.SETCycleNode;
import soot.dava.internal.SET.SETDoWhileNode;
import soot.dava.internal.SET.SETNode;
import soot.dava.internal.SET.SETUnconditionalWhileNode;
import soot.dava.internal.SET.SETWhileNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.asg.AugmentedStmtGraph;
import soot.dava.internal.javaRep.DIntConstant;
import soot.dava.toolkits.base.finders.ExceptionNode;
import soot.dava.toolkits.base.finders.FactFinder;
import soot.dava.toolkits.base.misc.ConditionFlipper;
import soot.grimp.internal.GAssignStmt;
import soot.grimp.internal.GTableSwitchStmt;
import soot.jimple.ConditionExpr;
import soot.jimple.GotoStmt;
import soot.jimple.IfStmt;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.internal.JGotoStmt;
import soot.toolkits.graph.StronglyConnectedComponentsFast;
import soot.util.IterableSet;
import soot.util.StationaryArrayList;

public class CycleFinder
implements FactFinder {
    private static final Logger logger = LoggerFactory.getLogger(CycleFinder.class);

    public CycleFinder(Singletons.Global g) {
    }

    public static CycleFinder v() {
        return G.v().soot_dava_toolkits_base_finders_CycleFinder();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void find(DavaBody body, AugmentedStmtGraph asg, SETNode SET) throws RetriggerAnalysisException {
        Dava.v().log("CycleFinder::find()");
        AugmentedStmtGraph wasg = (AugmentedStmtGraph)asg.clone();
        List<List<AugmentedStmt>> component_list = this.build_component_list(wasg);
        while (!component_list.isEmpty()) {
            IterableSet<AugmentedStmt> node_list = new IterableSet<AugmentedStmt>();
            for (List<AugmentedStmt> cal : component_list) {
                SETCycleNode newNode;
                void var12_12;
                Object au;
                node_list.clear();
                node_list.addAll(cal);
                IterableSet<AugmentedStmt> entry_points = this.get_EntryPoint(node_list);
                if (entry_points.size() > 1) {
                    LinkedList<AugmentedStmt> asgEntryPoints = new LinkedList<AugmentedStmt>();
                    for (AugmentedStmt augmentedStmt : entry_points) {
                        asgEntryPoints.addLast(asg.get_AugStmt(augmentedStmt.get_Stmt()));
                    }
                    IterableSet<AugmentedStmt> asgScc = new IterableSet<AugmentedStmt>();
                    for (AugmentedStmt augmentedStmt : node_list) {
                        asgScc.addLast(asg.get_AugStmt(augmentedStmt.get_Stmt()));
                    }
                    this.fix_MultiEntryPoint(body, asg, asgEntryPoints, asgScc);
                    throw new RetriggerAnalysisException();
                }
                AugmentedStmt succ_stmt = null;
                AugmentedStmt entry_point = (AugmentedStmt)entry_points.getFirst();
                AugmentedStmt augmentedStmt = this.find_CharacterizingStmt(entry_point, node_list, wasg);
                if (augmentedStmt != null) {
                    Iterator<AugmentedStmt> iterator = augmentedStmt.bsuccs.iterator();
                    while (iterator.hasNext() && node_list.contains(succ_stmt = (au = iterator.next()))) {
                    }
                }
                wasg.calculate_Reachability(succ_stmt, new HashSet<AugmentedStmt>(), entry_point);
                IterableSet<AugmentedStmt> iterableSet = this.get_CycleBody(entry_point, succ_stmt, asg, wasg);
                if (augmentedStmt != null) {
                    au = body.get_ExceptionFacts().iterator();
                    block5: while (au.hasNext()) {
                        ExceptionNode en = (ExceptionNode)au.next();
                        IterableSet<AugmentedStmt> tryBody = en.get_TryBody();
                        if (!tryBody.contains(asg.get_AugStmt(augmentedStmt.get_Stmt()))) continue;
                        for (AugmentedStmt cbas : iterableSet) {
                            if (tryBody.contains(cbas)) continue;
                            Object var12_17 = null;
                            break block5;
                        }
                    }
                }
                if (var12_12 == null) {
                    wasg.remove_AugmentedStmt(entry_point);
                    newNode = new SETUnconditionalWhileNode((IterableSet)iterableSet);
                } else {
                    body.consume_Condition(asg.get_AugStmt(var12_12.get_Stmt()));
                    wasg.remove_AugmentedStmt((AugmentedStmt)var12_12);
                    IfStmt condition = (IfStmt)var12_12.get_Stmt();
                    if (!iterableSet.contains(asg.get_AugStmt(condition.getTarget()))) {
                        condition.setCondition(ConditionFlipper.flip((ConditionExpr)condition.getCondition()));
                    }
                    newNode = var12_12 == entry_point ? new SETWhileNode(asg.get_AugStmt(var12_12.get_Stmt()), (IterableSet)iterableSet) : new SETDoWhileNode(asg.get_AugStmt(var12_12.get_Stmt()), asg.get_AugStmt(entry_point.get_Stmt()), iterableSet);
                }
                SET.nest(newNode);
            }
            component_list = this.build_component_list(wasg);
        }
    }

    private IterableSet<AugmentedStmt> get_EntryPoint(IterableSet<AugmentedStmt> nodeList) {
        IterableSet<AugmentedStmt> entryPoints = new IterableSet<AugmentedStmt>();
        block0: for (AugmentedStmt as : nodeList) {
            for (AugmentedStmt po : as.cpreds) {
                if (nodeList.contains(po)) continue;
                entryPoints.add(as);
                continue block0;
            }
        }
        return entryPoints;
    }

    private List<List<AugmentedStmt>> build_component_list(AugmentedStmtGraph asg) {
        LinkedList<List<AugmentedStmt>> c_list = new LinkedList<List<AugmentedStmt>>();
        for (List<AugmentedStmt> wcomp : new StronglyConnectedComponentsFast<AugmentedStmt>(asg).getComponents()) {
            AugmentedStmt as;
            int size = wcomp.size();
            if (size > 1) {
                c_list.add(wcomp);
                continue;
            }
            if (size != 1 || !as.cpreds.contains(as = wcomp.get(0)) || !as.csuccs.contains(as)) continue;
            StationaryArrayList currentComponent = new StationaryArrayList();
            currentComponent.add(as);
            c_list.add(currentComponent);
        }
        return c_list;
    }

    private AugmentedStmt find_CharacterizingStmt(AugmentedStmt entry_point, IterableSet<AugmentedStmt> sc_component, AugmentedStmtGraph asg) {
        if (entry_point.get_Stmt() instanceof IfStmt) {
            for (AugmentedStmt au : entry_point.bsuccs) {
                if (sc_component.contains(au)) continue;
                return entry_point;
            }
        }
        IterableSet<AugmentedStmt> candidates = new IterableSet<AugmentedStmt>();
        HashMap<AugmentedStmt, AugmentedStmt> candSuccMap = new HashMap<AugmentedStmt, AugmentedStmt>();
        HashSet<AugmentedStmt> blockers = new HashSet<AugmentedStmt>();
        block1: for (AugmentedStmt pas : entry_point.bpreds) {
            Stmt pasStmt = pas.get_Stmt();
            if (pasStmt instanceof GotoStmt && pas.bpreds.size() == 1) {
                pas = pas.bpreds.get(0);
            }
            if (!sc_component.contains(pas) || !(pasStmt instanceof IfStmt)) continue;
            for (AugmentedStmt spas : pas.bsuccs) {
                if (sc_component.contains(spas)) continue;
                candidates.add(pas);
                candSuccMap.put(pas, spas);
                blockers.add(spas);
                continue block1;
            }
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (AugmentedStmt)candidates.getFirst();
        }
        asg.calculate_Reachability(candidates, blockers, entry_point);
        IterableSet<AugmentedStmt> max_Reach_Set = null;
        int reachSize = 0;
        for (AugmentedStmt as : candidates) {
            int current_reach_size = ((AugmentedStmt)candSuccMap.get(as)).get_Reachers().intersection(candidates).size();
            if (current_reach_size > reachSize) {
                max_Reach_Set = new IterableSet<AugmentedStmt>();
                reachSize = current_reach_size;
            }
            if (current_reach_size != reachSize) continue;
            max_Reach_Set.add(as);
        }
        candidates = max_Reach_Set;
        if (candidates == null) {
            throw new RuntimeException("Did not find a suitable candidate");
        }
        if (candidates.size() == 1) {
            return (AugmentedStmt)candidates.getFirst();
        }
        HashSet<AugmentedStmt> touchSet = new HashSet<AugmentedStmt>();
        LinkedList<AugmentedStmt> worklist = new LinkedList<AugmentedStmt>();
        worklist.addLast(entry_point);
        touchSet.add(entry_point);
        while (!worklist.isEmpty()) {
            for (AugmentedStmt so : ((AugmentedStmt)worklist.removeFirst()).csuccs) {
                if (candidates.contains(so)) {
                    return so;
                }
                if (!sc_component.contains(so) || touchSet.contains(so)) continue;
                worklist.addLast(so);
                touchSet.add(so);
            }
        }
        throw new RuntimeException("Somehow didn't find a condition for a do-while loop!");
    }

    private IterableSet<AugmentedStmt> get_CycleBody(AugmentedStmt entry_point, AugmentedStmt boundary_stmt, AugmentedStmtGraph asg, AugmentedStmtGraph wasg) {
        IterableSet<AugmentedStmt> cycle_body = new IterableSet<AugmentedStmt>();
        LinkedList<AugmentedStmt> worklist = new LinkedList<AugmentedStmt>();
        AugmentedStmt asg_ep = asg.get_AugStmt(entry_point.get_Stmt());
        worklist.add(entry_point);
        cycle_body.add(asg_ep);
        while (!worklist.isEmpty()) {
            AugmentedStmt as = (AugmentedStmt)worklist.removeFirst();
            for (AugmentedStmt wsas : as.csuccs) {
                AugmentedStmt sas = asg.get_AugStmt(wsas.get_Stmt());
                if (cycle_body.contains(sas) || cycle_body.contains(sas) || !sas.get_Dominators().contains(asg_ep) || boundary_stmt != null && (wsas.get_Reachers().contains(boundary_stmt) || wsas == boundary_stmt)) continue;
                worklist.add(wsas);
                cycle_body.add(sas);
            }
        }
        return cycle_body;
    }

    private void fix_MultiEntryPoint(DavaBody body, AugmentedStmtGraph asg, LinkedList<AugmentedStmt> entry_points, IterableSet<AugmentedStmt> scc) {
        AugmentedStmt naturalEntryPoint = this.get_NaturalEntryPoint(entry_points, scc);
        Local controlLocal = body.get_ControlLocal();
        GTableSwitchStmt tss = new GTableSwitchStmt((Value)controlLocal, 0, entry_points.size() - 2, Collections.nCopies(entry_points.size(), null), naturalEntryPoint.get_Stmt());
        AugmentedStmt dispatchStmt = new AugmentedStmt(tss);
        IterableSet<AugmentedStmt> predecessorSet = new IterableSet<AugmentedStmt>();
        IterableSet<AugmentedStmt> indirectionStmtSet = new IterableSet<AugmentedStmt>();
        IterableSet<AugmentedStmt> directionStmtSet = new IterableSet<AugmentedStmt>();
        int count = 0;
        for (AugmentedStmt entryPoint : entry_points) {
            JGotoStmt gotoStmt = new JGotoStmt(entryPoint.get_Stmt());
            AugmentedStmt indirectionStmt = new AugmentedStmt(gotoStmt);
            indirectionStmtSet.add(indirectionStmt);
            tss.setTarget(count++, gotoStmt);
            dispatchStmt.add_BSucc(indirectionStmt);
            indirectionStmt.add_BPred(dispatchStmt);
            indirectionStmt.add_BSucc(entryPoint);
            entryPoint.add_BPred(indirectionStmt);
            asg.add_AugmentedStmt(indirectionStmt);
            LinkedList<AugmentedStmt> toRemove = new LinkedList<AugmentedStmt>();
            for (AugmentedStmt pas : entryPoint.cpreds) {
                if (pas == indirectionStmt || entryPoint != naturalEntryPoint && scc.contains(pas)) continue;
                if (!scc.contains(pas)) {
                    predecessorSet.add(pas);
                }
                GAssignStmt asnStmt = new GAssignStmt(controlLocal, DIntConstant.v(count, null));
                AugmentedStmt directionStmt = new AugmentedStmt(asnStmt);
                directionStmtSet.add(directionStmt);
                this.patch_Stmt(pas.get_Stmt(), entryPoint.get_Stmt(), asnStmt);
                toRemove.addLast(pas);
                pas.csuccs.remove(entryPoint);
                pas.csuccs.add(directionStmt);
                if (pas.bsuccs.contains(entryPoint)) {
                    pas.bsuccs.remove(entryPoint);
                    pas.bsuccs.add(directionStmt);
                }
                directionStmt.cpreds.add(pas);
                if (pas.bsuccs.contains(directionStmt)) {
                    directionStmt.bpreds.add(pas);
                }
                directionStmt.add_BSucc(dispatchStmt);
                dispatchStmt.add_BPred(directionStmt);
                asg.add_AugmentedStmt(directionStmt);
            }
            for (AugmentedStmt ras : toRemove) {
                entryPoint.cpreds.remove(ras);
                if (!entryPoint.bpreds.contains(ras)) continue;
                entryPoint.bpreds.remove(ras);
            }
        }
        asg.add_AugmentedStmt(dispatchStmt);
        block3: for (ExceptionNode en : body.get_ExceptionFacts()) {
            IterableSet<AugmentedStmt> tryBody = en.get_TryBody();
            for (AugmentedStmt au : entry_points) {
                if (tryBody.contains(au)) continue;
                continue block3;
            }
            en.add_TryStmts(indirectionStmtSet);
            en.add_TryStmt(dispatchStmt);
            for (AugmentedStmt au : predecessorSet) {
                if (tryBody.contains(au)) continue;
                continue block3;
            }
            en.add_TryStmts(directionStmtSet);
        }
    }

    private AugmentedStmt get_NaturalEntryPoint(LinkedList<AugmentedStmt> entry_points, IterableSet<AugmentedStmt> scc) {
        AugmentedStmt best_candidate = null;
        int minScore = 0;
        for (AugmentedStmt entryPoint : entry_points) {
            HashSet<AugmentedStmt> touchSet = new HashSet<AugmentedStmt>();
            HashSet<AugmentedStmt> backTargets = new HashSet<AugmentedStmt>();
            touchSet.add(entryPoint);
            this.DFS(entryPoint, touchSet, backTargets, scc);
            if (best_candidate != null && backTargets.size() >= minScore) continue;
            minScore = touchSet.size();
            best_candidate = entryPoint;
        }
        return best_candidate;
    }

    private void DFS(AugmentedStmt as, HashSet<AugmentedStmt> touchSet, HashSet<AugmentedStmt> backTargets, IterableSet<AugmentedStmt> scc) {
        for (AugmentedStmt sas : as.csuccs) {
            if (!scc.contains(sas)) continue;
            if (touchSet.contains(sas)) {
                if (backTargets.contains(sas)) continue;
                backTargets.add(sas);
                continue;
            }
            touchSet.add(sas);
            this.DFS(sas, touchSet, backTargets, scc);
            touchSet.remove(sas);
        }
    }

    private void patch_Stmt(Stmt src, Stmt oldDst, Stmt newDst) {
        int i;
        int e;
        if (src instanceof GotoStmt) {
            ((GotoStmt)src).setTarget(newDst);
            return;
        }
        if (src instanceof IfStmt) {
            IfStmt ifs = (IfStmt)src;
            if (ifs.getTarget() == oldDst) {
                ifs.setTarget(newDst);
            }
            return;
        }
        if (src instanceof TableSwitchStmt) {
            TableSwitchStmt tss = (TableSwitchStmt)src;
            if (tss.getDefaultTarget() == oldDst) {
                tss.setDefaultTarget(newDst);
                return;
            }
            e = tss.getHighIndex();
            for (i = tss.getLowIndex(); i <= e; ++i) {
                if (tss.getTarget(i) != oldDst) continue;
                tss.setTarget(i, newDst);
                return;
            }
        }
        if (src instanceof LookupSwitchStmt) {
            LookupSwitchStmt lss = (LookupSwitchStmt)src;
            if (lss.getDefaultTarget() == oldDst) {
                lss.setDefaultTarget(newDst);
                return;
            }
            e = lss.getTargetCount();
            for (i = 0; i < e; ++i) {
                if (lss.getTarget(i) != oldDst) continue;
                lss.setTarget(i, newDst);
                return;
            }
        }
    }
}

