/*
 * Decompiled with CFR 0.152.
 */
package soot.coffi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import soot.coffi.BasicBlock;

final class BBQ {
    private final ArrayList<BasicBlock> q = new ArrayList();

    BBQ() {
    }

    public void push(BasicBlock b) {
        if (!b.inq) {
            b.inq = true;
            this.q.add(b);
        }
    }

    public BasicBlock pull() throws NoSuchElementException {
        if (this.q.size() == 0) {
            throw new NoSuchElementException("Pull from empty BBQ");
        }
        BasicBlock b = this.q.get(0);
        this.q.remove(0);
        b.inq = false;
        return b;
    }

    public boolean contains(BasicBlock b) {
        return b.inq;
    }

    public int size() {
        return this.q.size();
    }

    public boolean isEmpty() {
        return this.q.isEmpty();
    }

    public void clear() {
        Iterator<BasicBlock> iterator = this.q.iterator();
        while (iterator.hasNext()) {
            BasicBlock basicBlock;
            BasicBlock b = basicBlock = iterator.next();
            b.inq = false;
        }
        this.q.clear();
    }
}

