/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.Unit;
import soot.UnitPrinter;
import soot.baf.InstSwitch;
import soot.baf.LookupSwitchInst;
import soot.baf.internal.AbstractSwitchInst;
import soot.jimple.IntConstant;
import soot.util.Switch;

public class BLookupSwitchInst
extends AbstractSwitchInst
implements LookupSwitchInst {
    List<IntConstant> lookupValues;

    public BLookupSwitchInst(Unit defaultTarget, List<IntConstant> lookupValues, List<? extends Unit> targets) {
        super(defaultTarget, targets);
        this.setLookupValues(lookupValues);
    }

    @Override
    public Object clone() {
        return new BLookupSwitchInst(this.getDefaultTarget(), this.lookupValues, this.getTargets());
    }

    @Override
    public void setLookupValues(List<IntConstant> lookupValues) {
        this.lookupValues = new ArrayList<IntConstant>(lookupValues);
    }

    @Override
    public void setLookupValue(int index, int value) {
        this.lookupValues.set(index, IntConstant.v(value));
    }

    @Override
    public int getLookupValue(int index) {
        return this.lookupValues.get((int)index).value;
    }

    @Override
    public List<IntConstant> getLookupValues() {
        return Collections.unmodifiableList(this.lookupValues);
    }

    @Override
    public String getName() {
        return "lookupswitch";
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        String endOfLine = " ";
        buffer.append("lookupswitch").append(endOfLine);
        buffer.append("{").append(endOfLine);
        for (int i = 0; i < this.lookupValues.size(); ++i) {
            buffer.append("    case ").append(this.lookupValues.get(i)).append(": goto ").append(this.getTarget(i)).append(";").append(endOfLine);
        }
        buffer.append("    default: goto ").append(this.getDefaultTarget()).append(";").append(endOfLine);
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("lookupswitch");
        up.newline();
        up.literal("{");
        up.newline();
        for (int i = 0; i < this.lookupValues.size(); ++i) {
            up.literal("    case ");
            up.constant(this.lookupValues.get(i));
            up.literal(": goto ");
            this.targetBoxes[i].toString(up);
            up.literal(";");
            up.newline();
        }
        up.literal("    default: goto ");
        this.defaultTargetBox.toString(up);
        up.literal(";");
        up.newline();
        up.literal("}");
    }

    @Override
    public void apply(Switch sw) {
        ((InstSwitch)sw).caseLookupSwitchInst(this);
    }
}

