/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import soot.AbstractJasminClass;
import soot.SootField;
import soot.SootFieldRef;
import soot.UnitPrinter;
import soot.baf.FieldGetInst;
import soot.baf.InstSwitch;
import soot.baf.internal.AbstractInst;
import soot.util.Switch;

public class BFieldGetInst
extends AbstractInst
implements FieldGetInst {
    SootFieldRef fieldRef;

    public BFieldGetInst(SootFieldRef fieldRef) {
        if (fieldRef.isStatic()) {
            throw new RuntimeException("wrong static-ness");
        }
        this.fieldRef = fieldRef;
    }

    @Override
    public Object clone() {
        return new BFieldGetInst(this.fieldRef);
    }

    @Override
    public int getInCount() {
        return 1;
    }

    @Override
    public int getInMachineCount() {
        return 1;
    }

    @Override
    public int getOutCount() {
        return 1;
    }

    @Override
    public int getOutMachineCount() {
        return AbstractJasminClass.sizeOfType(this.fieldRef.type());
    }

    @Override
    public final String getName() {
        return "fieldget";
    }

    @Override
    final String getParameters() {
        return " " + this.fieldRef.getSignature();
    }

    @Override
    protected void getParameters(UnitPrinter up) {
        up.literal(" ");
        up.fieldRef(this.fieldRef);
    }

    @Override
    public SootFieldRef getFieldRef() {
        return this.fieldRef;
    }

    @Override
    public SootField getField() {
        return this.fieldRef.resolve();
    }

    @Override
    public void apply(Switch sw) {
        ((InstSwitch)sw).caseFieldGetInst(this);
    }

    @Override
    public boolean containsFieldRef() {
        return true;
    }
}

