/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import soot.JastAddJ.PathPart;

public class FolderPart
extends PathPart {
    private Map<String, Collection<String>> packageMap = new HashMap<String, Collection<String>>();
    private final File folder;

    public FolderPart(File folder) {
        this.folder = folder;
    }

    @Override
    public boolean hasPackage(String name) {
        return !this.filesInPackage(name).isEmpty();
    }

    public boolean hasCompilationUnit(String canonicalName) {
        int index = canonicalName.lastIndexOf(46);
        String packageName = index == -1 ? "" : canonicalName.substring(0, index);
        String typeName = canonicalName.substring(index + 1, canonicalName.length());
        String fileName = typeName + this.fileSuffix();
        return this.filesInPackage(packageName).contains(fileName);
    }

    private Collection<String> filesInPackage(String packageName) {
        if (!this.packageMap.containsKey(packageName)) {
            int index = packageName.lastIndexOf(46);
            String name = packageName.substring(index == -1 ? 0 : index + 1);
            String folderName = packageName.replace('.', File.separatorChar);
            File pkgFolder = new File(this.folder, folderName);
            Collection<Object> fileSet = Collections.emptyList();
            try {
                String[] files;
                File canonical = pkgFolder.getCanonicalFile();
                if (canonical.isDirectory() && (packageName.isEmpty() || canonical.getName().equals(name)) && (files = canonical.list()).length > 0) {
                    fileSet = new HashSet();
                    for (String file : files) {
                        fileSet.add(file);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.packageMap.put(packageName, fileSet);
        }
        return this.packageMap.get(packageName);
    }

    @Override
    public boolean selectCompilationUnit(String canonicalName) throws IOException {
        String typeName;
        String fileName;
        File classFile;
        if (this.hasCompilationUnit(canonicalName) && (classFile = new File(this.folder, fileName = (typeName = canonicalName.replace('.', File.separatorChar)) + this.fileSuffix())).isFile()) {
            this.is = new FileInputStream(classFile);
            this.age = classFile.lastModified();
            this.pathName = classFile.getPath();
            this.relativeName = fileName + this.fileSuffix();
            this.fullName = canonicalName;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.folder.toString();
    }
}

