/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Unit;
import soot.UnitPrinter;
import soot.ValueBox;
import soot.tagkit.ColorTag;
import soot.tagkit.Host;
import soot.tagkit.JimpleLineNumberTag;
import soot.tagkit.PositionTag;
import soot.tagkit.Tag;

public class AttributesUnitPrinter {
    private static final Logger logger = LoggerFactory.getLogger(AttributesUnitPrinter.class);
    private Stack<Integer> startOffsets;
    private int endOffset;
    private int startStmtOffset;
    private int startLn;
    private int currentLn;
    private int lastNewline;
    private UnitPrinter printer;

    public AttributesUnitPrinter(int currentLnNum) {
        this.currentLn = currentLnNum;
    }

    public void startUnit(Unit u) {
        this.startLn = this.currentLn;
        this.startStmtOffset = this.outputLength() - this.lastNewline;
    }

    public void endUnit(Unit u) {
        int endStmtOffset = this.outputLength() - this.lastNewline;
        if (this.hasTag(u)) {
            u.addTag(new JimpleLineNumberTag(this.startLn, this.currentLn));
        }
        if (this.hasColorTag(u)) {
            u.addTag(new PositionTag(this.startStmtOffset, endStmtOffset));
        }
    }

    public void startValueBox(ValueBox u) {
        if (this.startOffsets == null) {
            this.startOffsets = new Stack();
        }
        this.startOffsets.push(this.outputLength() - this.lastNewline);
    }

    public void endValueBox(ValueBox u) {
        this.endOffset = this.outputLength() - this.lastNewline;
        if (this.hasColorTag(u)) {
            u.addTag(new PositionTag(this.startOffsets.pop(), this.endOffset));
        }
    }

    private boolean hasTag(Host h) {
        if (h instanceof Unit) {
            for (ValueBox box : ((Unit)h).getUseAndDefBoxes()) {
                if (!this.hasTag(box)) continue;
                return true;
            }
        }
        return !h.getTags().isEmpty();
    }

    private boolean hasColorTag(Host h) {
        for (Tag t : h.getTags()) {
            if (!(t instanceof ColorTag)) continue;
            return true;
        }
        return false;
    }

    public void setEndLn(int ln) {
        this.currentLn = ln;
    }

    public int getEndLn() {
        return this.currentLn;
    }

    public void newline() {
        ++this.currentLn;
        this.lastNewline = this.outputLength();
    }

    private int outputLength() {
        return this.printer.output().length();
    }

    public void setUnitPrinter(UnitPrinter up) {
        this.printer = up;
    }
}

