/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.StringTokenizer;
import polyglot.util.AbstractErrorQueue;
import polyglot.util.ErrorInfo;
import polyglot.util.Position;

public class StdErrorQueue
extends AbstractErrorQueue {
    private PrintStream err;

    public StdErrorQueue(PrintStream err, int limit, String name) {
        super(limit, name);
        this.err = err;
    }

    public void displayError(ErrorInfo e) {
        String message = e.getErrorKind() != 0 ? e.getMessage() : e.getErrorString() + " -- " + e.getMessage();
        Position position = e.getPosition();
        String prefix = position != null ? position.nameAndLineString() : this.name;
        int width = 0;
        this.err.print(prefix + ":");
        width += prefix.length() + 1;
        int lmargin = 4;
        int rmargin = 78;
        StringTokenizer lines = new StringTokenizer(message, "\n", true);
        boolean needNewline = false;
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            if (line.indexOf("\n") < 0) {
                StringTokenizer st = new StringTokenizer(line, " ");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if (width + s.length() + 1 > rmargin) {
                        this.err.println();
                        for (int i = 0; i < lmargin; ++i) {
                            this.err.print(" ");
                        }
                        width = lmargin;
                    } else {
                        this.err.print(" ");
                        ++width;
                    }
                    this.err.print(s);
                    width += s.length();
                }
                needNewline = true;
            } else {
                this.err.println();
                needNewline = false;
            }
            width = lmargin;
            if (lines.hasMoreTokens()) {
                for (int i = 0; i < lmargin; ++i) {
                    this.err.print(" ");
                }
                continue;
            }
            if (!needNewline) continue;
            this.err.println();
        }
        if (position != null) {
            this.showError(position);
        }
    }

    protected void tooManyErrors(ErrorInfo lastError) {
        Position position = lastError.getPosition();
        String prefix = position != null ? position.file() + ": " : "";
        this.err.println(prefix + "Too many errors.  Aborting compilation.");
    }

    protected Reader reader(Position pos) throws IOException {
        if (pos.file() != null && pos.line() != -1) {
            return new FileReader(pos.file());
        }
        return null;
    }

    private void showError(Position pos) {
        try {
            Reader r = this.reader(pos);
            if (r == null) {
                return;
            }
            LineNumberReader reader = new LineNumberReader(r);
            String s = null;
            while (reader.getLineNumber() < pos.line()) {
                s = reader.readLine();
            }
            if (s != null) {
                this.err.println(s);
                this.showErrorIndicator(pos, reader.getLineNumber(), s);
                if (pos.endLine() != pos.line() && pos.endLine() != -1 && pos.endLine() != -2) {
                    if (pos.endLine() - pos.line() > 1) {
                        for (int j = 0; j < s.length() && Character.isWhitespace(s.charAt(j)); ++j) {
                            this.err.print(s.charAt(j));
                        }
                        this.err.println("...");
                    }
                    while (reader.getLineNumber() < pos.endLine()) {
                        s = reader.readLine();
                    }
                    if (s != null) {
                        this.err.println(s);
                        this.showErrorIndicator(pos, reader.getLineNumber(), s);
                    }
                }
            }
            reader.close();
            this.err.println();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void showErrorIndicator(Position pos, int lineNum, String s) {
        if (pos.column() == -1) {
            return;
        }
        int i = 0;
        while (i < s.length() && Character.isWhitespace(s.charAt(i))) {
            this.err.print(s.charAt(i++));
        }
        int startIndAt = i;
        int stopIndAt = s.length() - 1;
        if (pos.line() == lineNum) {
            startIndAt = pos.column();
        }
        if (pos.endLine() == lineNum) {
            stopIndAt = pos.endColumn() - 1;
        }
        if (stopIndAt < startIndAt) {
            stopIndAt = startIndAt;
        }
        if (pos.endColumn() == -1 || pos.endColumn() == -2) {
            stopIndAt = startIndAt;
        }
        while (i <= stopIndAt) {
            int c = 45;
            if (i < startIndAt) {
                c = 32;
            }
            if (i < s.length() && s.charAt(i) == '\t') {
                c = 9;
            }
            if (i == startIndAt && pos.line() == lineNum) {
                c = 94;
            }
            if (i == stopIndAt && pos.endLine() == lineNum) {
                c = 94;
            }
            this.err.print((char)c);
            ++i;
        }
        this.err.println();
    }

    public void flush() {
        if (!this.flushed && this.errorCount() > 0) {
            this.err.println(this.errorCount() + " error" + (this.errorCount() > 1 ? "s." : "."));
        }
        super.flush();
    }
}

