/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.types;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import polyglot.ext.jl.types.ReferenceType_c;
import polyglot.main.Options;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.Named;
import polyglot.types.Package;
import polyglot.types.ReferenceType;
import polyglot.types.Resolver;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.Translator;

public abstract class ClassType_c
extends ReferenceType_c
implements ClassType {
    protected ClassType_c() {
    }

    public ClassType_c(TypeSystem ts) {
        this(ts, null);
    }

    public ClassType_c(TypeSystem ts, Position pos) {
        super(ts, pos);
    }

    public abstract ClassType.Kind kind();

    public abstract ClassType outer();

    public abstract String name();

    public ReferenceType container() {
        if (!this.isMember()) {
            throw new InternalCompilerError("Non-member classes cannot have container classes.");
        }
        if (this.outer() == null) {
            throw new InternalCompilerError("Nested classes must have outer classes.");
        }
        return this.outer();
    }

    public String fullName() {
        String name = this.isAnonymous() ? (this.superType() != null ? "<anon subtype of " + ((Object)this.superType()).toString() + ">" : "<anon subtype of unknown>") : this.name();
        if (this.isTopLevel() && this.package_() != null) {
            return this.package_().fullName() + "." + name;
        }
        if (this.isMember() && this.container() instanceof Named) {
            return ((Named)((Object)this.container())).fullName() + "." + name;
        }
        return name;
    }

    public boolean isTopLevel() {
        return this.kind() == ClassType.TOP_LEVEL;
    }

    public boolean isMember() {
        return this.kind() == ClassType.MEMBER;
    }

    public boolean isLocal() {
        return this.kind() == ClassType.LOCAL;
    }

    public boolean isAnonymous() {
        return this.kind() == ClassType.ANONYMOUS;
    }

    public final boolean isInner() {
        return this.isNested();
    }

    public boolean isNested() {
        return this.kind() == ClassType.MEMBER || this.kind() == ClassType.LOCAL || this.kind() == ClassType.ANONYMOUS;
    }

    public boolean isInnerClass() {
        return !this.flags().isInterface() && this.isNested() && !this.flags().isStatic() && !this.inStaticContext();
    }

    public boolean isCanonical() {
        return true;
    }

    public boolean isClass() {
        return true;
    }

    public ClassType toClass() {
        return this;
    }

    public abstract Package package_();

    public abstract Flags flags();

    public abstract List constructors();

    public abstract List memberClasses();

    public abstract List methods();

    public abstract List fields();

    public abstract List interfaces();

    public abstract Type superType();

    public FieldInstance fieldNamed(String name) {
        Iterator i = this.fields().iterator();
        while (i.hasNext()) {
            FieldInstance fi = (FieldInstance)i.next();
            if (!fi.name().equals(name)) continue;
            return fi;
        }
        return null;
    }

    public ClassType memberClassNamed(String name) {
        Iterator i = this.memberClasses().iterator();
        while (i.hasNext()) {
            ClassType t = (ClassType)i.next();
            if (!t.name().equals(name)) continue;
            return t;
        }
        return null;
    }

    public boolean descendsFromImpl(Type ancestor) {
        if (!ancestor.isCanonical()) {
            return false;
        }
        if (ancestor.isNull()) {
            return false;
        }
        if (this.ts.equals(this, ancestor)) {
            return false;
        }
        if (!ancestor.isReference()) {
            return false;
        }
        if (this.ts.equals(ancestor, this.ts.Object())) {
            return true;
        }
        if (!this.flags().isInterface()) {
            if (this.ts.equals(this, this.ts.Object())) {
                return false;
            }
            if (this.superType() == null) {
                return false;
            }
            if (this.ts.isSubtype(this.superType(), ancestor)) {
                return true;
            }
        }
        Iterator i = this.interfaces().iterator();
        while (i.hasNext()) {
            Type parentType = (Type)i.next();
            if (!this.ts.isSubtype(parentType, ancestor)) continue;
            return true;
        }
        return false;
    }

    public boolean isThrowable() {
        return this.ts.isSubtype(this, this.ts.Throwable());
    }

    public boolean isUncheckedException() {
        if (this.isThrowable()) {
            Collection c = this.ts.uncheckedExceptions();
            Iterator i = c.iterator();
            while (i.hasNext()) {
                Type t = (Type)i.next();
                if (!this.ts.isSubtype(this, t)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isImplicitCastValidImpl(Type toType) {
        if (!toType.isClass()) {
            return false;
        }
        return this.ts.isSubtype(this, toType);
    }

    public boolean isCastValidImpl(Type toType) {
        if (!toType.isCanonical()) {
            return false;
        }
        if (!toType.isReference()) {
            return false;
        }
        if (toType.isArray()) {
            return this.ts.isSubtype(toType, this);
        }
        if (!toType.isClass()) {
            return false;
        }
        boolean fromInterface = this.flags().isInterface();
        boolean toInterface = toType.toClass().flags().isInterface();
        boolean fromFinal = this.flags().isFinal();
        boolean toFinal = toType.toClass().flags().isFinal();
        if (!fromInterface) {
            if (!toInterface) {
                return this.ts.isSubtype(this, toType) || this.ts.isSubtype(toType, this);
            }
            if (fromFinal) {
                return this.ts.isSubtype(this, toType);
            }
            return true;
        }
        if (!toInterface && !toFinal) {
            return true;
        }
        if (toFinal) {
            return this.ts.isSubtype(toType, this);
        }
        return true;
    }

    public final boolean isEnclosed(ClassType maybe_outer) {
        return this.ts.isEnclosed(this, maybe_outer);
    }

    public final boolean hasEnclosingInstance(ClassType encl) {
        return this.ts.hasEnclosingInstance(this, encl);
    }

    public String translate(Resolver c) {
        if (this.isTopLevel()) {
            if (this.package_() == null) {
                return this.name();
            }
            if (c != null) {
                try {
                    Named x = c.find(this.name());
                    if (this.ts.equals(this, x)) {
                        return this.name();
                    }
                }
                catch (SemanticException e) {
                    // empty catch block
                }
            }
            if (Options.global.cppBackend()) {
                return Translator.cScope(this.package_().translate(c) + "." + this.name());
            }
            return this.package_().translate(c) + "." + this.name();
        }
        if (this.isMember()) {
            if (this.container().toClass().isAnonymous()) {
                return this.name();
            }
            if (c != null) {
                try {
                    Named x = c.find(this.name());
                    if (this.ts.equals(this, x)) {
                        return this.name();
                    }
                }
                catch (SemanticException semanticException) {
                    // empty catch block
                }
            }
            return this.container().translate(c) + "." + this.name();
        }
        if (this.isLocal()) {
            return this.name();
        }
        throw new InternalCompilerError("Cannot translate an anonymous class.");
    }

    public String toString() {
        if (this.isTopLevel()) {
            if (this.package_() != null) {
                return this.package_().toString() + "." + this.name();
            }
            return this.name();
        }
        if (this.isMember()) {
            return this.container().toString() + "." + this.name();
        }
        if (this.isLocal()) {
            return this.name();
        }
        if (this.superType() != null) {
            return "<anon subtype of " + ((Object)this.superType()).toString() + ">";
        }
        return "<anon subtype of unknown>";
    }

    public boolean isEnclosedImpl(ClassType maybe_outer) {
        if (this.isTopLevel()) {
            return false;
        }
        if (this.outer() != null) {
            return this.outer().equals(maybe_outer) || this.outer().isEnclosed(maybe_outer);
        }
        throw new InternalCompilerError("Non top-level classes must have outer classes.");
    }

    public boolean hasEnclosingInstanceImpl(ClassType encl) {
        if (this.equals(encl)) {
            return true;
        }
        if (!this.isInnerClass() || this.inStaticContext()) {
            return false;
        }
        return this.outer().hasEnclosingInstance(encl);
    }
}

