/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.jl.ast;

import polyglot.ast.AmbAssign;
import polyglot.ast.ArrayAccess;
import polyglot.ast.Assign;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ext.jl.ast.Assign_c;
import polyglot.types.SemanticException;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;

public class AmbAssign_c
extends Assign_c
implements AmbAssign {
    public AmbAssign_c(Position pos, Expr left, Assign.Operator op, Expr right) {
        super(pos, left, op, right);
    }

    public Term entry() {
        if (this.operator() != Assign.ASSIGN) {
            return this.left();
        }
        return this.right().entry();
    }

    protected void acceptCFGAssign(CFGBuilder v) {
        v.visitCFG((Term)this.right(), this);
    }

    protected void acceptCFGOpAssign(CFGBuilder v) {
        v.edge(this.left(), this.right().entry());
        v.visitCFG((Term)this.right(), this);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        Assign n = (Assign)super.disambiguate(ar);
        if (n.left() instanceof Local) {
            return ar.nodeFactory().LocalAssign(n.position(), (Local)this.left(), this.operator(), this.right());
        }
        if (n.left() instanceof Field) {
            return ar.nodeFactory().FieldAssign(n.position(), (Field)this.left(), this.operator(), this.right());
        }
        if (n.left() instanceof ArrayAccess) {
            return ar.nodeFactory().ArrayAccessAssign(n.position(), (ArrayAccess)this.left(), this.operator(), this.right());
        }
        throw new SemanticException("Could not disambiguate left side of assignment!", n.position());
    }
}

