/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.org.mvel2.templates.res;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import org.eclipse.emt4j.org.mvel2.MVEL;
import org.eclipse.emt4j.org.mvel2.ParserContext;
import org.eclipse.emt4j.org.mvel2.integration.VariableResolverFactory;
import org.eclipse.emt4j.org.mvel2.templates.CompiledTemplate;
import org.eclipse.emt4j.org.mvel2.templates.TemplateCompiler;
import org.eclipse.emt4j.org.mvel2.templates.TemplateError;
import org.eclipse.emt4j.org.mvel2.templates.TemplateRuntime;
import org.eclipse.emt4j.org.mvel2.templates.res.Node;
import org.eclipse.emt4j.org.mvel2.templates.util.TemplateOutputStream;
import org.eclipse.emt4j.org.mvel2.templates.util.TemplateTools;

public class CompiledIncludeNode
extends Node {
    private Serializable cIncludeExpression;
    private Serializable cPreExpression;
    private long fileDateStamp;
    private CompiledTemplate cFileCache;
    private ParserContext context;

    public CompiledIncludeNode(int begin, String name, char[] template, int start, int end, ParserContext context) {
        this.begin = begin;
        this.name = name;
        this.contents = template;
        this.cStart = start;
        this.cEnd = end - 1;
        this.end = end;
        this.context = context;
        int mark = TemplateTools.captureToEOS(this.contents, this.cStart);
        this.cIncludeExpression = MVEL.compileExpression(this.contents, this.cStart, mark - this.cStart, context);
        if (mark != this.contents.length) {
            this.cPreExpression = MVEL.compileExpression(this.contents, ++mark, this.cEnd - mark, context);
        }
    }

    @Override
    public Object eval(TemplateRuntime runtime, TemplateOutputStream appender, Object ctx, VariableResolverFactory factory) {
        String file = MVEL.executeExpression((Object)this.cIncludeExpression, ctx, factory, String.class);
        if (this.cPreExpression != null) {
            MVEL.executeExpression((Object)this.cPreExpression, ctx, factory);
        }
        if (this.next != null) {
            return this.next.eval(runtime, appender.append(String.valueOf(TemplateRuntime.eval(this.readFile(runtime, file, ctx, factory), ctx, factory))), ctx, factory);
        }
        return appender.append(String.valueOf(MVEL.eval(this.readFile(runtime, file, ctx, factory), ctx, factory)));
    }

    private String readFile(TemplateRuntime runtime, String fileName, Object ctx, VariableResolverFactory factory) {
        File file = new File(String.valueOf(runtime.getRelPath().peek()) + "/" + fileName);
        if (this.fileDateStamp == 0L || this.fileDateStamp != file.lastModified()) {
            this.fileDateStamp = file.lastModified();
            this.cFileCache = TemplateCompiler.compileTemplate(CompiledIncludeNode.readInFile(runtime, file), this.context);
        }
        return String.valueOf(TemplateRuntime.execute(this.cFileCache, ctx, factory));
    }

    @Override
    public boolean demarcate(Node terminatingNode, char[] template) {
        return false;
    }

    public static String readInFile(TemplateRuntime runtime, File file) {
        FileInputStream instream = null;
        BufferedReader in = null;
        StringBuilder appender = new StringBuilder();
        try {
            String currentLine;
            instream = CompiledIncludeNode.openInputStream(file);
            runtime.getRelPath().push(file.getParent());
            in = new BufferedReader(new InputStreamReader((InputStream)instream, "UTF-8"));
            while ((currentLine = in.readLine()) != null) {
                appender.append(currentLine);
            }
            runtime.getRelPath().pop();
            String string = appender.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            throw new TemplateError("cannot include template '" + file.getPath() + "': file not found.");
        }
        catch (IOException e) {
            throw new TemplateError("unknown I/O exception while including '" + file.getPath() + "' (stacktrace nested)", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new TemplateError("cannot close the reader on template file '" + file.getPath() + "'.");
                }
            }
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    throw new TemplateError("cannot close the stream on template file '" + file.getPath() + "'.");
                }
            }
        }
    }

    private static FileInputStream openInputStream(File file) throws IOException {
        if (file == null) {
            throw new FileNotFoundException("file parameter is null");
        }
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }
}

