/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.org.mvel2.sh.command.file;

import java.io.File;
import org.eclipse.emt4j.org.mvel2.sh.Command;
import org.eclipse.emt4j.org.mvel2.sh.CommandException;
import org.eclipse.emt4j.org.mvel2.sh.ShellSession;

public class DirList
implements Command {
    @Override
    public Object execute(ShellSession session, String[] args) {
        File current = new File(session.getEnv().get("$CWD"));
        if (!current.isDirectory()) {
            throw new CommandException("cannot list directory : " + session.getEnv().get("$CWD") + " is not a directory");
        }
        File[] files = current.listFiles();
        if (files.length == 0) {
            return null;
        }
        System.out.append("Total ").append(String.valueOf(files.length)).append("\n");
        for (File file : current.listFiles()) {
            if (file.isDirectory()) {
                System.out.append(file.getName()).append("/");
            } else {
                System.out.append(file.getName());
            }
            System.out.append("\n");
        }
        System.out.flush();
        return null;
    }

    @Override
    public String getDescription() {
        return "performs a list of files and directories in the current working dir.";
    }

    @Override
    public String getHelp() {
        return "no help yet";
    }
}

