/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.org.mvel2.integration.impl;

import java.util.HashMap;
import org.eclipse.emt4j.org.mvel2.ast.Function;
import org.eclipse.emt4j.org.mvel2.integration.VariableResolver;
import org.eclipse.emt4j.org.mvel2.integration.VariableResolverFactory;
import org.eclipse.emt4j.org.mvel2.integration.impl.BaseVariableResolverFactory;
import org.eclipse.emt4j.org.mvel2.integration.impl.LocalVariableResolverFactory;
import org.eclipse.emt4j.org.mvel2.integration.impl.SimpleValueResolver;

public class FunctionVariableResolverFactory
extends BaseVariableResolverFactory
implements LocalVariableResolverFactory {
    private Function function;
    private boolean noTilt = false;

    public FunctionVariableResolverFactory(Function function, VariableResolverFactory nextFactory, String[] indexedVariables, Object[] parameters) {
        this.function = function;
        this.variableResolvers = new HashMap();
        this.nextFactory = nextFactory;
        this.indexedVariableNames = indexedVariables;
        this.indexedVariableResolvers = new VariableResolver[indexedVariables.length];
        for (int i = 0; i < parameters.length; ++i) {
            this.variableResolvers.put(this.indexedVariableNames[i], null);
            this.indexedVariableResolvers[i] = new SimpleValueResolver(parameters[i]);
        }
    }

    @Override
    public boolean isResolveable(String name) {
        return this.variableResolvers.containsKey(name) || this.nextFactory != null && this.nextFactory.isResolveable(name);
    }

    @Override
    public VariableResolver createVariable(String name, Object value) {
        VariableResolver resolver = this.getVariableResolver(name);
        if (resolver == null) {
            int idx = this.increaseRegisterTableSize();
            this.indexedVariableNames[idx] = name;
            this.indexedVariableResolvers[idx] = new SimpleValueResolver(value);
            this.variableResolvers.put(name, null);
            return this.indexedVariableResolvers[idx];
        }
        resolver.setValue(value);
        return resolver;
    }

    @Override
    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        VariableResolver vr;
        VariableResolver variableResolver = vr = this.variableResolvers != null ? (VariableResolver)this.variableResolvers.get(name) : null;
        if (vr != null && vr.getType() != null) {
            throw new RuntimeException("variable already defined within scope: " + vr.getType() + " " + name);
        }
        return this.createIndexedVariable(this.variableIndexOf(name), name, value);
    }

    @Override
    public VariableResolver createIndexedVariable(int index, String name, Object value) {
        if (this.indexedVariableResolvers[index -= this.indexOffset] != null) {
            this.indexedVariableResolvers[index].setValue(value);
        } else {
            this.indexedVariableResolvers[index] = new SimpleValueResolver(value);
        }
        this.variableResolvers.put(name, null);
        return this.indexedVariableResolvers[index];
    }

    @Override
    public VariableResolver createIndexedVariable(int index, String name, Object value, Class<?> type) {
        if (this.indexedVariableResolvers[index -= this.indexOffset] != null) {
            this.indexedVariableResolvers[index].setValue(value);
        } else {
            this.indexedVariableResolvers[index] = new SimpleValueResolver(value);
        }
        return this.indexedVariableResolvers[index];
    }

    @Override
    public VariableResolver getIndexedVariableResolver(int index) {
        if (this.indexedVariableResolvers[index] == null) {
            this.indexedVariableResolvers[index] = super.getVariableResolver(this.indexedVariableNames[index]);
            return this.indexedVariableResolvers[index];
        }
        return this.indexedVariableResolvers[index];
    }

    @Override
    public VariableResolver getVariableResolver(String name) {
        int idx = this.variableIndexOf(name);
        if (idx != -1) {
            if (this.indexedVariableResolvers[idx] == null) {
                this.indexedVariableResolvers[idx] = new SimpleValueResolver(null);
            }
            this.variableResolvers.put(this.indexedVariableNames[idx], null);
            return this.indexedVariableResolvers[idx];
        }
        return super.getVariableResolver(name);
    }

    @Override
    public boolean isIndexedFactory() {
        return true;
    }

    @Override
    public boolean isTarget(String name) {
        return this.variableResolvers.containsKey(name) || this.variableIndexOf(name) != -1;
    }

    private int increaseRegisterTableSize() {
        String[] oldNames = this.indexedVariableNames;
        VariableResolver[] oldResolvers = this.indexedVariableResolvers;
        int newLength = oldNames.length + 1;
        this.indexedVariableNames = new String[newLength];
        this.indexedVariableResolvers = new VariableResolver[newLength];
        for (int i = 0; i < oldNames.length; ++i) {
            this.indexedVariableNames[i] = oldNames[i];
            this.indexedVariableResolvers[i] = oldResolvers[i];
        }
        return newLength - 1;
    }

    public void updateParameters(Object[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            this.indexedVariableResolvers[i] = new SimpleValueResolver(parameters[i]);
        }
    }

    public VariableResolver[] getIndexedVariableResolvers() {
        return this.indexedVariableResolvers;
    }

    public void setIndexedVariableResolvers(VariableResolver[] vr) {
        this.indexedVariableResolvers = vr;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setIndexOffset(int offset) {
        this.indexOffset = offset;
    }

    public VariableResolverFactory setNoTilt(boolean noTilt) {
        this.noTilt = noTilt;
        return this;
    }

    @Override
    public void setTiltFlag(boolean tiltFlag) {
        if (!this.noTilt) {
            super.setTiltFlag(tiltFlag);
        }
    }
}

