/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.staticanalysis;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emt4j.common.staticanalysis.Analyzer;
import org.eclipse.emt4j.common.staticanalysis.Invoker;
import org.eclipse.emt4j.common.staticanalysis.impl.CLDRCalendarFirstDayOfWeekAnalyzer;
import org.eclipse.emt4j.common.staticanalysis.impl.CLDRDateFormatAnalyzer;
import org.eclipse.emt4j.common.staticanalysis.impl.CLDRNumberFormatAnalyzer;
import org.eclipse.emt4j.common.staticanalysis.impl.CastArraysAsListToArrayAnalyzer;
import org.eclipse.emt4j.common.staticanalysis.impl.CastSystemClassLoaderToURLClassLoaderAnalyzer;
import org.eclipse.emt4j.common.staticanalysis.impl.PatternCompileAnalyzer;
import soot.G;
import soot.Scene;
import soot.SootClass;
import soot.options.Options;

class InvokerImpl
implements Invoker {
    private final File directory;
    private final Map<String, Analyzer> analyzerMap = new HashMap<String, Analyzer>();

    InvokerImpl() throws IOException {
        this.directory = Files.createTempDirectory("files-for-static-analysis-" + Thread.currentThread().getId() + "-", new FileAttribute[0]).toFile();
        System.out.println(this.directory.getAbsolutePath());
        this.directory.deleteOnExit();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                Files.walk(this.directory.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
        this.add(new CastArraysAsListToArrayAnalyzer());
        this.add(new PatternCompileAnalyzer());
        this.add(new CastSystemClassLoaderToURLClassLoaderAnalyzer());
        this.add(new CLDRDateFormatAnalyzer());
        this.add(new CLDRCalendarFirstDayOfWeekAnalyzer());
        this.add(new CLDRNumberFormatAnalyzer());
    }

    private void add(Analyzer analyzer) {
        this.analyzerMap.put(analyzer.rule(), analyzer);
    }

    private void reset() {
        G.v();
        G.reset();
        Options.v().set_prepend_classpath(true);
        Options.v().set_allow_phantom_refs(true);
        Options.v().set_keep_line_number(true);
        Options.v().set_soot_classpath(this.directory.getAbsolutePath());
    }

    private Path writeTo(String className, byte[] bytecodes) {
        String[] split = className.split("\\.");
        File current = this.directory;
        for (int i = 0; i < split.length - 1; ++i) {
            current = new File(current, split[i]);
            current.mkdir();
        }
        try {
            return Files.write(current.toPath().resolve(split[split.length - 1] + ".class"), bytecodes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean invoke(String rule, String className, byte[] bytecodes) {
        if (className.endsWith("module-info") || className.endsWith("package-info")) {
            return false;
        }
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - ".class".length());
        }
        this.reset();
        Analyzer analyzer = this.analyzerMap.get(rule);
        Path path = this.writeTo(className, bytecodes);
        try {
            SootClass clazz = Scene.v().loadClassAndSupport(className);
            clazz.setApplicationClass();
            Scene.v().loadNecessaryClasses();
            boolean bl = analyzer.analyze(clazz);
            return bl;
        }
        finally {
            path.toFile().delete();
        }
    }
}

