/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.rule.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emt4j.common.DependTarget;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.RuleImpl;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.model.CheckResult;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;
import org.eclipse.emt4j.common.util.ClassURL;
import org.eclipse.emt4j.common.util.FileUtil;

@RuleImpl(type="deprecated-api")
public class DeprecatedAPIRule
extends ExecutableRule {
    private String classListFile;
    private Set<String> deprecatedClasses = new HashSet<String>();
    private Set<DependTarget.Method> deprecatedMethods = new HashSet<DependTarget.Method>();

    public DeprecatedAPIRule(ConfRuleItem confRuleItem, ConfRules confRules) {
        super(confRuleItem, confRules);
    }

    @Override
    public void init() {
        FileUtil.readPlainTextFromResource(this.confRules.getRuleDataPathPrefix() + this.classListFile, false).forEach(l -> {
            String[] nameMethodDesc = l.split(",");
            if ("*".equals(nameMethodDesc[1])) {
                this.deprecatedClasses.add(nameMethodDesc[0]);
            } else {
                this.deprecatedMethods.add(new DependTarget.Method(nameMethodDesc[0], nameMethodDesc[1], nameMethodDesc[2], DependType.METHOD));
            }
        });
    }

    @Override
    protected CheckResult check(Dependency dependency) {
        Set methods = dependency.getClassSymbol().getCallMethodSet().stream().filter(m -> this.deprecatedClasses.contains(m.getClassName()) || this.deprecatedMethods.contains(m)).collect(Collectors.toSet());
        if (methods.isEmpty()) {
            return CheckResult.PASS;
        }
        CheckResult result = CheckResult.fail();
        result.setPropagated(methods.stream().map(m -> new Dependency(ClassURL.create(dependency.getLocationExternalForm(), dependency.getTarget().asClass().getClassName(), ""), (DependTarget)m, null, dependency.getTargetFilePath())).collect(Collectors.toList()));
        return result;
    }

    @Override
    public boolean accept(Dependency dependency) {
        return DependType.WHOLE_CLASS == dependency.getDependType();
    }

    public void setClassListFile(String classListFile) {
        this.classListFile = classListFile;
    }
}

