/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.rule;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.emt4j.common.JdkMigrationException;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;
import org.eclipse.emt4j.common.util.MutableBoolean;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfRuleRepository {
    private static final String[] FIXED_ATTR_NAME = new String[]{"desc", "type", "result-code", "sub-result-code", "support-modes", "priority"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<ConfRules> load(String feature, int fromVersion, int toVersion) throws URISyntaxException, IOException, SAXException {
        if (null == feature) throw new RuntimeException("feature cannot be null or empty!");
        if ("".equals(feature)) {
            throw new RuntimeException("feature cannot be null or empty!");
        }
        for (char c : feature.toCharArray()) {
            if (Character.isLetterOrDigit(c)) continue;
            throw new RuntimeException("feature must be number or digit");
        }
        String basePath = "/" + feature + "/rule/" + fromVersion + "to" + toVersion;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(ConfRuleRepository.class.getResource("/xsd/rules.xsd").toURI().toURL());
        Validator validator = schema.newValidator();
        final MutableBoolean error = new MutableBoolean();
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
                error.setValue(true);
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
                error.setValue(true);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                exception.printStackTrace();
                error.setValue(true);
            }
        });
        String rulePath = basePath + "/rule.xml";
        try (InputStream is = ConfRuleRepository.class.getResourceAsStream(rulePath);){
            if (is == null) {
                Optional<ConfRules> optional = Optional.empty();
                return optional;
            }
            validator.validate(new StreamSource(is));
            if (error.isValue()) {
                throw new JdkMigrationException("XSD validation failed for file: " + rulePath);
            }
        }
        try {
            is = ConfRuleRepository.class.getResourceAsStream(rulePath);
            var10_14 = null;
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                RuleConfSAXHandler ruleConfSAXHandler = new RuleConfSAXHandler();
                saxParser.parse(is, (DefaultHandler)ruleConfSAXHandler);
                ConfRules confRules = new ConfRules();
                confRules.setRuleDataPathPrefix(basePath + "/data/");
                confRules.setFromVersion(fromVersion);
                confRules.setToVersion(toVersion);
                confRules.setFeature(feature);
                confRules.setRuleItems(ruleConfSAXHandler.ruleItems);
                Optional<ConfRules> optional = Optional.of(confRules);
                return optional;
            }
            catch (Throwable throwable) {
                var10_14 = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (var10_14 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            var10_14.addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Cannot found rule config for feature:" + feature + ",fromVersion:" + fromVersion + ",toVersion:" + toVersion, e);
        }
    }

    private static class RuleConfSAXHandler
    extends DefaultHandler {
        private StringBuilder currentValue = new StringBuilder();
        List<ConfRuleItem> ruleItems = new ArrayList<ConfRuleItem>();
        private ConfRuleItem confRuleItem;

        private RuleConfSAXHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.currentValue.setLength(0);
            if (qName.equals("rule")) {
                this.confRuleItem = new ConfRuleItem();
                this.confRuleItem.setDesc(attributes.getValue("desc"));
                this.confRuleItem.setType(attributes.getValue("type"));
                this.confRuleItem.setResultCode(attributes.getValue("result-code"));
                this.confRuleItem.setSubResultCode(attributes.getValue("sub-result-code"));
                this.confRuleItem.setPriority(attributes.getValue("priority"));
                ArrayList<String[]> userDefineAttrs = new ArrayList<String[]>(attributes.getLength());
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attrName = attributes.getLocalName(i);
                    if (this.isFixedAttribute(attrName)) continue;
                    userDefineAttrs.add(new String[]{attrName, attributes.getValue(i)});
                }
                this.confRuleItem.setUserDefineAttrs(userDefineAttrs);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("rule")) {
                this.ruleItems.add(this.confRuleItem);
            }
            if (qName.equals("mode")) {
                this.confRuleItem.getSupportModes().add(this.currentValue.toString());
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.currentValue.append(ch, start, length);
        }

        private boolean isFixedAttribute(String attrName) {
            return Arrays.stream(FIXED_ATTR_NAME).anyMatch(attrName::equals);
        }
    }
}

