/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.rule;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emt4j.common.rule.ConfRuleRepository;
import org.eclipse.emt4j.common.rule.model.ConfRules;
import org.eclipse.emt4j.common.util.FileUtil;
import org.xml.sax.SAXException;

public class ConfRuleFacade {
    private static final int[] JDK_UPGRADE_ROADMAP;

    public static List<ConfRules> load(String[] features, String[] modes, int fromVersion, int toVersion) throws SAXException, IOException, URISyntaxException {
        int[][] roadmap = ConfRuleFacade.findWays(fromVersion, toVersion);
        if (roadmap == null) {
            throw new RuntimeException("Not a valid fromVersion: " + fromVersion + ",toVersion:" + toVersion + " pair!");
        }
        ArrayList<ConfRules> confRulesList = new ArrayList<ConfRules>();
        for (int[] oneWay : roadmap) {
            for (String feature : features) {
                Optional<ConfRules> confRules = ConfRuleRepository.load(feature, oneWay[0], oneWay[1]);
                confRules.ifPresent(v -> {
                    if (v.getRuleItems() != null) {
                        v.setRuleItems(v.getRuleItems().stream().filter(r -> ConfRuleFacade.intersect(r.getSupportModes(), modes)).collect(Collectors.toList()));
                    }
                    confRulesList.add((ConfRules)v);
                });
            }
        }
        return confRulesList;
    }

    private static boolean intersect(List<String> supportModes, String[] modes) {
        for (String supportMode : supportModes) {
            for (String mode : modes) {
                if (!supportMode.equals(mode)) continue;
                return true;
            }
        }
        return false;
    }

    public static int[][] findWays(int fromVersion, int toVersion) {
        int fromIndex = -1;
        int toIndex = -1;
        for (int i = 0; i < JDK_UPGRADE_ROADMAP.length; ++i) {
            if (JDK_UPGRADE_ROADMAP[i] == fromVersion) {
                fromIndex = i;
                continue;
            }
            if (JDK_UPGRADE_ROADMAP[i] != toVersion) continue;
            toIndex = i;
        }
        if (fromIndex == -1 || toIndex == -1 || fromIndex == toIndex || toIndex < fromIndex) {
            return null;
        }
        int[][] ways = new int[toIndex - fromIndex][2];
        for (int i = fromIndex; i < toIndex; ++i) {
            ways[i - fromIndex][0] = JDK_UPGRADE_ROADMAP[i];
            ways[i - fromIndex][1] = JDK_UPGRADE_ROADMAP[i + 1];
        }
        return ways;
    }

    public static String getFeatureI18nBase(String feature) {
        return feature + ".i18n.";
    }

    static {
        String[] roadMapStr = FileUtil.readPlainTextFromResource("/roadmap.cfg", false).get(0).split("->");
        JDK_UPGRADE_ROADMAP = new int[roadMapStr.length];
        for (int i = 0; i < roadMapStr.length; ++i) {
            ConfRuleFacade.JDK_UPGRADE_ROADMAP[i] = Integer.parseInt(roadMapStr[i]);
        }
    }
}

