/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.common.classanalyze;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.eclipse.emt4j.common.ClassSymbol;
import org.eclipse.emt4j.common.DependTarget;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.classanalyze.ClassMethodsAccessor;
import org.eclipse.emt4j.org.objectweb.asm.AnnotationVisitor;
import org.eclipse.emt4j.org.objectweb.asm.ClassReader;
import org.eclipse.emt4j.org.objectweb.asm.ClassVisitor;
import org.eclipse.emt4j.org.objectweb.asm.Label;
import org.eclipse.emt4j.org.objectweb.asm.MethodVisitor;
import org.eclipse.emt4j.org.objectweb.asm.Type;
import org.eclipse.emt4j.org.objectweb.asm.TypePath;

public class AsmClassMethodsAccessor
implements ClassMethodsAccessor {
    static AtomicReference<String> currentMethod = new AtomicReference();

    @Override
    public void visitGivenMethodList(Class targetClass, List<String> methodNameList, MethodVisitor methodVisitor) {
        this.readClass(targetClass, b -> this.visit((byte[])b, methodNameList, methodVisitor));
    }

    private void readClass(Class targetClass, Consumer<byte[]> consumer) {
        String name = targetClass.getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        try (InputStream in = targetClass.getResourceAsStream(name + ".class");){
            if (in != null) {
                int len;
                ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
                byte[] buffer = new byte[4096];
                while ((len = in.read(buffer)) != -1) {
                    bos.write(buffer, 0, len);
                }
                consumer.accept(bos.toByteArray());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String visit(byte[] bytecode, final List<String> methodNameList, final MethodVisitor methodVisitor) {
        ClassReader cr = new ClassReader(bytecode);
        cr.accept(new ClassVisitor(589824){

            @Override
            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                String resultingParams = AsmClassMethodsAccessor.retrieveParameters(descriptor);
                String methodFullName = resultingParams.isEmpty() ? name : name + "(" + resultingParams + ")";
                currentMethod.set(methodFullName);
                if (null == methodNameList || methodNameList.contains(name)) {
                    return methodVisitor;
                }
                return super.visitMethod(access, name, descriptor, signature, exceptions);
            }
        }, 0);
        return cr.getClassName();
    }

    private static String retrieveParameters(String descriptor) {
        int endPos = descriptor.lastIndexOf(")");
        String params = descriptor.substring(1, endPos);
        int paraStartPos = 0;
        StringBuilder resultingParams = new StringBuilder();
        int dimension = 0;
        block11: while (paraStartPos < params.length()) {
            if (params.charAt(paraStartPos) == 'L') {
                int paraEndPos = params.indexOf(";", paraStartPos);
                String param = params.substring(paraStartPos + 1, paraEndPos).replace('/', '.');
                resultingParams.append(param);
                paraStartPos = paraEndPos + 1;
            } else {
                char primitiveType = params.charAt(paraStartPos++);
                switch (primitiveType) {
                    case 'Z': {
                        resultingParams.append("boolean");
                        break;
                    }
                    case 'I': {
                        resultingParams.append("int");
                        break;
                    }
                    case 'F': {
                        resultingParams.append("float");
                        break;
                    }
                    case 'D': {
                        resultingParams.append("double");
                        break;
                    }
                    case 'C': {
                        resultingParams.append("char");
                        break;
                    }
                    case 'B': {
                        resultingParams.append("byte");
                        break;
                    }
                    case 'J': {
                        resultingParams.append("long");
                        break;
                    }
                    case 'S': {
                        resultingParams.append("short");
                        break;
                    }
                    case '[': {
                        ++dimension;
                        continue block11;
                    }
                    default: {
                        throw new RuntimeException("Unknown type " + primitiveType + " in parameter types descriptor " + descriptor);
                    }
                }
            }
            while (dimension > 0) {
                resultingParams.append("[]");
                --dimension;
            }
            resultingParams.append(";");
        }
        if (resultingParams.length() > 0) {
            resultingParams.deleteCharAt(resultingParams.length() - 1);
        }
        return resultingParams.toString();
    }

    @Override
    public Set<String> getReferenceClassSet(Class targetClass) {
        RecordSymbolMethodVisitor methodVisitor = new RecordSymbolMethodVisitor();
        this.readClass(targetClass, b -> this.visit((byte[])b, null, methodVisitor));
        return methodVisitor.getTypeSet();
    }

    @Override
    public Set<String> getReferenceClassSet(byte[] bytecode) {
        RecordSymbolMethodVisitor methodVisitor = new RecordSymbolMethodVisitor();
        this.visit(bytecode, null, methodVisitor);
        return methodVisitor.getTypeSet();
    }

    @Override
    public ClassSymbol getSymbolInClass(Class targetClass) {
        RecordSymbolMethodVisitor methodVisitor = new RecordSymbolMethodVisitor();
        this.readClass(targetClass, b -> this.visit((byte[])b, null, methodVisitor));
        return AsmClassMethodsAccessor.createClassSymbol(methodVisitor, targetClass.getName());
    }

    private static ClassSymbol createClassSymbol(RecordSymbolMethodVisitor methodVisitor, String className) {
        ClassSymbol classSymbol = new ClassSymbol();
        classSymbol.setCallMethodSet(methodVisitor.callMethodSet);
        classSymbol.setCallMethodToLines(methodVisitor.callMethodToLines);
        classSymbol.setConstantPoolSet(methodVisitor.constantPoolSet);
        classSymbol.setTypeSet(methodVisitor.typeSet);
        classSymbol.setClassName(className);
        return classSymbol;
    }

    @Override
    public ClassSymbol getSymbolInClass(byte[] bytecode) {
        RecordSymbolMethodVisitor methodVisitor = new RecordSymbolMethodVisitor();
        String className = this.visit(bytecode, null, methodVisitor);
        return AsmClassMethodsAccessor.createClassSymbol(methodVisitor, className);
    }

    private static class RecordSymbolMethodVisitor
    extends MethodVisitor {
        private int currentLine;
        Set<String> typeSet = new HashSet<String>();
        Set<DependTarget.Method> callMethodSet = new HashSet<DependTarget.Method>();
        Map<DependTarget.Method, List<Integer>> callMethodToLines = new HashMap<DependTarget.Method, List<Integer>>();
        Set<String> constantPoolSet = new HashSet<String>();

        public RecordSymbolMethodVisitor() {
            super(589824);
        }

        public Set<String> getTypeSet() {
            return this.typeSet;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            this.add(this.parseInternalForms(descriptor));
            return super.visitAnnotation(descriptor, visible);
        }

        void add(String maybeClass) {
            if (maybeClass != null) {
                this.typeSet.add(maybeClass);
            }
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            this.add(descriptor);
            return super.visitTypeAnnotation(typeRef, typePath, descriptor, visible);
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            this.add(descriptor);
            return super.visitParameterAnnotation(parameter, descriptor, visible);
        }

        @Override
        public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
            if (numLocal > 0 && local != null) {
                for (Object o : local) {
                    if (!(o instanceof String)) continue;
                    this.addLocalAndStack((String)o);
                }
            }
            if (numStack > 0 && stack != null) {
                for (Object o : stack) {
                    if (!(o instanceof String)) continue;
                    this.addLocalAndStack((String)o);
                }
            }
            super.visitFrame(type, numLocal, local, numStack, stack);
        }

        private void addLocalAndStack(String o) {
            if (o.length() > 1) {
                if ((o.charAt(0) == '[' || o.charAt(0) == 'L') && o.charAt(o.length() - 1) == ';') {
                    this.add(this.parseInternalForms(o));
                } else {
                    this.add(this.normalize(o));
                }
            }
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            this.add(this.normalize(type));
            super.visitTypeInsn(opcode, type);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            this.add(this.normalize(owner));
            this.add(this.parseInternalForms(descriptor));
            super.visitFieldInsn(opcode, owner, name, descriptor);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            this.add(this.normalize(owner));
            this.add(this.parseMethodDescriptor(descriptor));
            DependTarget.Method dependTarget = new DependTarget.Method(this.normalize(owner), name, descriptor, DependType.METHOD);
            this.callMethodSet.add(dependTarget);
            this.callMethodToLines.computeIfAbsent(dependTarget, i -> new ArrayList()).add(this.currentLine);
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            this.currentLine = line;
            super.visitLineNumber(line, start);
        }

        private void add(List<String> classNames) {
            for (String className : classNames) {
                this.add(className);
            }
        }

        private String normalize(String internal) {
            if (null != internal) {
                return internal.replace('/', '.');
            }
            return null;
        }

        private List<String> parseMethodDescriptor(String descriptor) {
            if (null == descriptor) {
                return null;
            }
            String paramPart = descriptor.substring(descriptor.indexOf(40) + 1, descriptor.indexOf(41));
            String returnPart = descriptor.substring(descriptor.indexOf(41) + 1);
            ArrayList<String> classNames = new ArrayList<String>();
            classNames.addAll(this.parseInternalForms(paramPart));
            classNames.addAll(this.parseReturnPart(returnPart));
            return classNames;
        }

        private Collection<? extends String> parseReturnPart(String returnPart) {
            if ("V".equals(returnPart)) {
                return Collections.emptyList();
            }
            return this.parseInternalForms(returnPart);
        }

        private List<String> parseInternalForms(String internalForm) {
            ArrayList<String> classNames = new ArrayList<String>();
            char[] chars = internalForm.toCharArray();
            boolean findingClass = false;
            StringBuilder classNameSb = new StringBuilder(64);
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (findingClass) {
                    if (c == ';') {
                        classNames.add(this.normalize(this.normalize(classNameSb.toString())));
                        classNameSb.setLength(0);
                        findingClass = false;
                        continue;
                    }
                    classNameSb.append(c);
                    continue;
                }
                if (c == 'B' || c == 'C' || c == 'D' || c == 'F' || c == 'I' || c == 'J' || c == 'S' || c == 'Z' || c == '[') continue;
                if (c == 'L') {
                    findingClass = true;
                    continue;
                }
                throw new RuntimeException("Unknown descriptor: " + internalForm);
            }
            return classNames;
        }

        @Override
        public void visitLdcInsn(Object value) {
            if (value instanceof String) {
                this.add((String)value);
                this.constantPoolSet.add((String)value);
            } else if (value instanceof Type) {
                Type type = (Type)value;
                int sort = type.getSort();
                if (sort == 10) {
                    this.add(type.getClassName());
                    this.constantPoolSet.add(type.getClassName());
                } else if (sort == 9) {
                    Type elementElementType;
                    Type elementType = type.getElementType();
                    if (elementType.getSort() == 10) {
                        this.add(elementType.getClassName());
                        this.constantPoolSet.add(elementType.getClassName());
                    } else if (elementType.getSort() == 9 && (elementElementType = elementType.getElementType()).getSort() == 10) {
                        this.add(elementElementType.getClassName());
                        this.constantPoolSet.add(elementElementType.getClassName());
                    }
                }
            }
            super.visitLdcInsn(value);
        }

        @Override
        public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
            this.add(this.parseInternalForms(descriptor));
            super.visitMultiANewArrayInsn(descriptor, numDimensions);
        }

        @Override
        public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
            this.add(this.parseInternalForms(descriptor));
            super.visitLocalVariable(name, descriptor, signature, start, end, index);
        }
    }
}

