/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common.rule.javaversion;

import java.util.Optional;
import org.eclipse.emt4j.agent.common.AgentFacade;
import org.eclipse.emt4j.agent.common.DependencyBuilder;
import org.eclipse.emt4j.agent.common.jdkdependent.CallerInfo;
import org.eclipse.emt4j.agent.common.methodvisitor.BaseEnterCallback;

public class GetJavaVersionCallback
extends BaseEnterCallback {
    private static final String[] ALL_PROPERTY_KEY = new String[]{"java.version", "java.specification.version", "java.runtime.version"};

    public static void check(String key) {
        Optional<CallerInfo> callerInfo;
        if (key != null && !key.isEmpty() && key.charAt(0) != 'j') {
            return;
        }
        Optional<Class> callerClass = AgentFacade.getCallerProvider().getNonJdkCallerByDepth(4);
        if (callerClass.isPresent() && GetJavaVersionCallback.isNotMySelf(callerClass.get()) && (callerInfo = AgentFacade.getCallerProvider().getCallerInfo(callerClass.get(), 3)).isPresent()) {
            for (String jdkVersionKey : ALL_PROPERTY_KEY) {
                if (!jdkVersionKey.equals(key)) continue;
                AgentFacade.record(DependencyBuilder.buildMethod(callerInfo.get(), callerInfo.get().getCalleeClass(), callerInfo.get().getCalleeMethod()));
            }
        }
    }
}

