/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common.rule;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emt4j.agent.common.MethodVisitorParam;
import org.eclipse.emt4j.agent.common.methodvisitor.TransformerFactory;
import org.eclipse.emt4j.agent.common.rule.accessible.SetInstanceAccessibleMethodVisitor;
import org.eclipse.emt4j.agent.common.rule.accessible.SetStaticAccessibleMethodVisitor;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.MethodDesc;
import org.eclipse.emt4j.common.RuleImpl;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.model.CheckResult;
import org.eclipse.emt4j.common.rule.model.ConfRuleItem;
import org.eclipse.emt4j.common.rule.model.ConfRules;
import org.eclipse.emt4j.common.util.ClassUtil;
import org.eclipse.emt4j.common.util.FileUtil;
import org.eclipse.emt4j.common.util.JdkClassUtil;

@RuleImpl(type="add-opens")
public class AddOpensRule
extends ExecutableRule {
    private String packagesFile;
    private String moduleToPackageFile;
    protected Map<String, String> exportPackageToModule = new HashMap<String, String>();
    private Set<String> packageSet = new HashSet<String>();
    private MethodDesc[] callMethods = new MethodDesc[]{new MethodDesc("java/lang/reflect/AccessibleObject", "java.lang.reflect.AccessibleObject", "setAccessible", "(Z)V"), new MethodDesc("java/lang/reflect/AccessibleObject", "java.lang.reflect.AccessibleObject", "setAccessible", "([Ljava/lang/reflect/AccessibleObject;Z)V")};

    public AddOpensRule(ConfRuleItem confRuleItem, ConfRules confRules) {
        super(confRuleItem, confRules);
    }

    @Override
    public void init() {
        FileUtil.readPlainTextFromResource(this.confRules.getRuleDataPathPrefix() + this.moduleToPackageFile, false).forEach(l -> {
            String[] arr = l.split(",");
            this.exportPackageToModule.put(arr[0].trim(), arr[1].trim());
        });
        this.packageSet.addAll(FileUtil.readPlainTextFromResource(this.confRules.getRuleDataPathPrefix() + this.packagesFile, false));
        TransformerFactory.register(this.callMethods[0], mvp -> new SetInstanceAccessibleMethodVisitor((MethodVisitorParam)mvp));
        TransformerFactory.register(this.callMethods[1], mvp -> new SetStaticAccessibleMethodVisitor((MethodVisitorParam)mvp));
    }

    @Override
    public CheckResult check(Dependency dependency) {
        if (!JdkClassUtil.isJdkClass(dependency.getTarget().asClass().getClassName())) {
            return CheckResult.PASS;
        }
        Optional<String> packageName = ClassUtil.getPackage(dependency.getTarget().asClass().getClassName());
        if (packageName.isPresent()) {
            String[] modulePackage = this.matchModule(packageName.get());
            if (modulePackage != null && this.packageSet.contains(modulePackage[1])) {
                return this.buildAddOpenOption(modulePackage[0], modulePackage[1]);
            }
            return CheckResult.PASS;
        }
        return CheckResult.PASS;
    }

    private CheckResult buildAddOpenOption(String sourceModule, String sourcePackage) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("sourceModule", sourceModule);
        context.put("sourcePackage", sourcePackage);
        return CheckResult.fail(context);
    }

    private String[] matchModule(String packageName) {
        String currPackage = packageName;
        String module = this.exportPackageToModule.get(packageName);
        if (module == null) {
            int index = packageName.lastIndexOf(46);
            while (index != -1) {
                currPackage = packageName.substring(0, index);
                module = this.exportPackageToModule.get(currPackage);
                if (module != null) {
                    return new String[]{module, currPackage};
                }
                index = packageName.substring(0, index).lastIndexOf(46);
            }
            return null;
        }
        return new String[]{module, currPackage};
    }

    @Override
    public boolean accept(Dependency dependency) {
        return DependType.METHOD_TO_CLASS_DEEP_REFLECTION == dependency.getDependType();
    }

    public void setPackagesFile(String packagesFile) {
        this.packagesFile = packagesFile;
    }

    public void setModuleToPackageFile(String moduleToPackageFile) {
        this.moduleToPackageFile = moduleToPackageFile;
    }
}

