/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common.file;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.emt4j.agent.common.file.CheckResultFileWriter;
import org.eclipse.emt4j.agent.common.file.Recorder;
import org.eclipse.emt4j.common.DependType;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.InstanceRuleManager;
import org.eclipse.emt4j.common.rule.model.ReportCheckResult;

public class ReportRecorder
implements Recorder {
    private BlockingQueue<Dependency> writeBuffer;
    private Thread writeThread;
    private Set<Integer> alreadyWritten = new HashSet<Integer>();
    private CheckResultFileWriter checkResultFileWriter;

    public ReportRecorder(CheckResultFileWriter writer) {
        this.writeBuffer = new LinkedBlockingQueue<Dependency>();
        this.checkResultFileWriter = writer;
    }

    @Override
    public void record(Dependency dependency) throws InterruptedException {
        if (dependency != null) {
            this.writeBuffer.put(dependency);
        }
    }

    @Override
    public boolean init() throws IOException {
        this.checkResultFileWriter.begin();
        this.writeThread = new Thread(() -> {
            try {
                try {
                    while (true) {
                        Dependency dependency;
                        int hashCode;
                        if (this.alreadyWritten.contains(hashCode = (dependency = this.writeBuffer.take()).hashCode())) {
                            continue;
                        }
                        this.publish(dependency);
                        this.alreadyWritten.add(hashCode);
                    }
                }
                catch (Throwable e) {
                    System.err.println("Write report thread occur exception,so exit");
                    e.printStackTrace();
                    try {
                        this.checkResultFileWriter.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    this.checkResultFileWriter.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
        }, "AgentReportWriteThread");
        this.writeThread.setDaemon(true);
        this.writeThread.start();
        return true;
    }

    private void publish(Dependency dependency) throws IOException {
        if (dependency.getDependType() == DependType.CODE_SOURCE) {
            this.checkResultFileWriter.write(dependency, null, null);
        }
        List<ExecutableRule> ruleList = InstanceRuleManager.getRuleInstanceList();
        for (ExecutableRule rule : ruleList) {
            List<Dependency> more;
            if (!rule.accept(dependency)) continue;
            ReportCheckResult checkResult = rule.execute(dependency);
            if (!checkResult.isPass()) {
                if (checkResult.getPropagated().isEmpty()) {
                    this.checkResultFileWriter.write(dependency, checkResult, rule);
                } else {
                    for (Dependency newDependency : checkResult.getPropagated()) {
                        this.checkResultFileWriter.write(newDependency, checkResult, rule);
                    }
                }
            }
            if ((more = rule.propagate(dependency)).isEmpty()) continue;
            this.publishMore(more);
        }
    }

    private void publishMore(List<Dependency> more) throws IOException {
        List<ExecutableRule> ruleList = InstanceRuleManager.getRuleInstanceList();
        for (Dependency dependency : more) {
            for (ExecutableRule rule : ruleList) {
                ReportCheckResult checkResult;
                if (!rule.accept(dependency) || (checkResult = rule.execute(dependency)).isPass()) continue;
                if (checkResult.getPropagated().isEmpty()) {
                    this.checkResultFileWriter.write(dependency, checkResult, rule);
                    continue;
                }
                for (Dependency newDependency : checkResult.getPropagated()) {
                    this.checkResultFileWriter.write(newDependency, checkResult, rule);
                }
            }
        }
    }
}

