/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.List;
import org.eclipse.emt4j.agent.common.file.CheckResultFileWriter;
import org.eclipse.emt4j.common.Dependency;
import org.eclipse.emt4j.common.fileformat.BodyRecord;
import org.eclipse.emt4j.common.fileformat.FixedHeader;
import org.eclipse.emt4j.common.fileformat.VariableHeader;
import org.eclipse.emt4j.common.rule.ExecutableRule;
import org.eclipse.emt4j.common.rule.model.ReportCheckResult;

public class BinaryFileWriter
implements CheckResultFileWriter {
    private final File output;
    private final int fromVersion;
    private final int toVersion;
    private ObjectOutputStream oos;
    private List<String> features;

    public BinaryFileWriter(File output, int fromVersion, int toVersion, List<String> features) {
        this.output = output;
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        this.features = features;
    }

    @Override
    public void begin() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.output);
        this.oos = new ObjectOutputStream(fos);
        this.oos.writeObject(this.getFixHeader());
        this.oos.writeObject(this.getVariableHeader());
        this.oos.flush();
    }

    @Override
    public void write(Dependency dependency, ReportCheckResult checkResult, ExecutableRule rule) throws IOException {
        BodyRecord br = new BodyRecord();
        br.setCheckResult(checkResult);
        br.setDependency(dependency);
        if (rule != null) {
            br.setFeature(rule.getConfRules().getFeature());
        }
        this.oos.writeObject(br);
        this.oos.flush();
    }

    private VariableHeader getVariableHeader() {
        VariableHeader vh = new VariableHeader();
        vh.setFromVersion(this.fromVersion);
        vh.setToVersion(this.toVersion);
        vh.setDate(new Date());
        vh.setVmOption(this.getVmOption());
        vh.setFeatures(this.features);
        return vh;
    }

    private String getVmOption() {
        return String.join((CharSequence)" ", ManagementFactory.getRuntimeMXBean().getInputArguments());
    }

    private FixedHeader getFixHeader() {
        FixedHeader fh = new FixedHeader();
        fh.setMagic(0x68686868);
        fh.setVersion(1);
        return fh;
    }

    @Override
    public void close() throws IOException {
        this.oos.close();
    }
}

