/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emt4j.agent.common;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import org.eclipse.emt4j.agent.common.AgentFacade;
import org.eclipse.emt4j.agent.common.InspectClassVisitor;
import org.eclipse.emt4j.agent.common.methodvisitor.TransformerFactory;
import org.eclipse.emt4j.org.objectweb.asm.ClassReader;
import org.eclipse.emt4j.org.objectweb.asm.ClassWriter;

public class InspectTransformer
implements ClassFileTransformer {
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (className == null || className.startsWith("org/eclipse/emt4j/agent") || className.startsWith("org/eclipse/emt4j/common") || className.equals("jdk/jfr/internal/instrument/ThrowableTracer")) {
            return null;
        }
        try {
            if (protectionDomain != null && protectionDomain.getCodeSource() != null && protectionDomain.getCodeSource().getLocation() != null) {
                AgentFacade.recordLoadJar(protectionDomain);
            }
            AgentFacade.recordLoadClass(className.replaceAll("/", "."), protectionDomain, classfileBuffer);
            if (TransformerFactory.needTransformByInternalClassName(className)) {
                return this.getInstrumentBytes(loader, classfileBuffer, className);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        return null;
    }

    private byte[] getInstrumentBytes(ClassLoader loader, byte[] originByteCode, String className) {
        try {
            ClassReader cr = new ClassReader(originByteCode);
            ClassWriter cw = new ClassWriter(cr, 0);
            InspectClassVisitor cv = new InspectClassVisitor(cw, className);
            cr.accept(cv, 0);
            return cw.toByteArray();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

