/*
 * Decompiled with CFR 0.152.
 */
package fj.function;

import fj.F;
import fj.F2;
import fj.Function;
import fj.Monoid;
import fj.Semigroup;
import fj.data.List;
import fj.data.Option;

public final class Doubles {
    public static final F<Double, F<Double, Double>> add = Semigroup.doubleAdditionSemigroup.sum();
    public static final F<Double, F<Double, Double>> multiply = Semigroup.doubleMultiplicationSemigroup.sum();
    public static final F<Double, F<Double, Double>> subtract = Function.curry(new F2<Double, Double, Double>(){

        @Override
        public Double f(Double x, Double y) {
            return x - y;
        }
    });
    public static final F<Double, Double> negate = new F<Double, Double>(){

        @Override
        public Double f(Double x) {
            return x * -1.0;
        }
    };
    public static final F<Double, Double> abs = new F<Double, Double>(){

        @Override
        public Double f(Double x) {
            return Math.abs(x);
        }
    };
    public static final F<Double, F<Double, Double>> remainder = Function.curry(new F2<Double, Double, Double>(){

        @Override
        public Double f(Double a, Double b) {
            return a % b;
        }
    });
    public static final F<Double, F<Double, Double>> power = Function.curry(new F2<Double, Double, Double>(){

        @Override
        public Double f(Double a, Double b) {
            return StrictMath.pow(a, b);
        }
    });
    public static final F<Double, Boolean> even = new F<Double, Boolean>(){

        @Override
        public Boolean f(Double i) {
            return i % 2.0 == 0.0;
        }
    };
    public static final F<Double, Boolean> gtZero = new F<Double, Boolean>(){

        @Override
        public Boolean f(Double i) {
            return Double.compare(i, 0.0) > 0;
        }
    };
    public static final F<Double, Boolean> gteZero = new F<Double, Boolean>(){

        @Override
        public Boolean f(Double i) {
            return Double.compare(i, 0.0) >= 0;
        }
    };
    public static final F<Double, Boolean> ltZero = new F<Double, Boolean>(){

        @Override
        public Boolean f(Double i) {
            return Double.compare(i, 0.0) < 0;
        }
    };
    public static final F<Double, Boolean> lteZero = new F<Double, Boolean>(){

        @Override
        public Boolean f(Double i) {
            return Double.compare(i, 0.0) <= 0;
        }
    };

    private Doubles() {
        throw new UnsupportedOperationException();
    }

    public static double sum(List<Double> doubles) {
        return Monoid.doubleAdditionMonoid.sumLeft(doubles);
    }

    public static double product(List<Double> doubles) {
        return Monoid.doubleMultiplicationMonoid.sumLeft(doubles);
    }

    public static F<String, Option<Double>> fromString() {
        return new F<String, Option<Double>>(){

            @Override
            public Option<Double> f(String s) {
                try {
                    return Option.some(Double.valueOf(s));
                }
                catch (NumberFormatException ignored) {
                    return Option.none();
                }
            }
        };
    }
}

