/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.web.spi.configuration;

import java.util.Objects;

public class WebServiceSettings {
    private boolean useDefaultContext = false;
    private String apiConfigKey;
    private Integer defaultPort;
    private String defaultPath;
    private String contextAlias;
    private String name;

    private WebServiceSettings() {
    }

    public String apiConfigKey() {
        return this.apiConfigKey;
    }

    public Integer getDefaultPort() {
        return this.defaultPort;
    }

    public String getDefaultPath() {
        return this.defaultPath;
    }

    public String getContextAlias() {
        return this.contextAlias;
    }

    public boolean useDefaultContext() {
        return this.useDefaultContext;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.useDefaultContext, this.apiConfigKey, this.defaultPort, this.defaultPath, this.contextAlias, this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebServiceSettings that = (WebServiceSettings)o;
        return this.useDefaultContext == that.useDefaultContext && this.apiConfigKey.equals(that.apiConfigKey) && this.defaultPort.equals(that.defaultPort) && this.defaultPath.equals(that.defaultPath) && Objects.equals(this.contextAlias, that.contextAlias) && this.name.equals(that.name);
    }

    public static class Builder {
        private final WebServiceSettings settings = new WebServiceSettings();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder contextAlias(String contextAlias) {
            this.settings.contextAlias = contextAlias;
            return this;
        }

        public Builder defaultPath(String defaultPath) {
            this.settings.defaultPath = defaultPath;
            return this;
        }

        public Builder apiConfigKey(String apiConfigKey) {
            this.settings.apiConfigKey = apiConfigKey;
            return this;
        }

        public Builder name(String name) {
            this.settings.name = name;
            return this;
        }

        public Builder defaultPort(int defaultPort) {
            this.settings.defaultPort = defaultPort;
            return this;
        }

        public Builder useDefaultContext(boolean useDefaultContext) {
            this.settings.useDefaultContext = useDefaultContext;
            return this;
        }

        public WebServiceSettings build() {
            Objects.requireNonNull(this.settings.apiConfigKey);
            Objects.requireNonNull(this.settings.defaultPath);
            Objects.requireNonNull(this.settings.defaultPort);
            Objects.requireNonNull(this.settings.name);
            return this.settings;
        }
    }
}

