/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.web.spi.exception;

import java.util.function.Function;
import org.eclipse.edc.service.spi.result.ServiceFailure;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.ObjectConflictException;
import org.eclipse.edc.web.spi.exception.ObjectNotFoundException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceResultHandler {
    public static EdcException mapToException(@NotNull ServiceFailure failure, @NotNull Class<?> clazz) {
        return ServiceResultHandler.mapToException(failure, clazz, null);
    }

    public static EdcException mapToException(@NotNull ServiceFailure failure, @NotNull Class<?> clazz, @Nullable String id) {
        switch (failure.getReason()) {
            case NOT_FOUND: {
                return new ObjectNotFoundException(clazz, id);
            }
            case CONFLICT: {
                return new ObjectConflictException(failure.getMessages());
            }
            case BAD_REQUEST: {
                return new InvalidRequestException(failure.getMessages());
            }
        }
        return new EdcException("unexpected error: " + failure.getFailureDetail());
    }

    public static Function<ServiceFailure, EdcException> exceptionMapper(@NotNull Class<?> clazz) {
        return serviceFailure -> ServiceResultHandler.mapToException(serviceFailure, clazz, null);
    }

    public static Function<ServiceFailure, EdcException> exceptionMapper(@NotNull Class<?> clazz, @Nullable String id) {
        return serviceFailure -> ServiceResultHandler.mapToException(serviceFailure, clazz, id);
    }
}

