/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.web.spi.configuration;

import org.eclipse.edc.spi.monitor.Monitor;
import org.eclipse.edc.spi.system.ServiceExtensionContext;
import org.eclipse.edc.spi.system.configuration.Config;
import org.eclipse.edc.web.spi.WebServer;
import org.eclipse.edc.web.spi.configuration.WebServiceConfiguration;
import org.eclipse.edc.web.spi.configuration.WebServiceConfigurer;
import org.eclipse.edc.web.spi.configuration.WebServiceSettings;

public class WebServiceConfigurerImpl
implements WebServiceConfigurer {
    @Override
    public WebServiceConfiguration configure(ServiceExtensionContext context, WebServer webServer, WebServiceSettings settings) {
        String apiConfig = settings.apiConfigKey();
        Config config = context.getConfig(apiConfig);
        Integer port = settings.getDefaultPort();
        String path = settings.getDefaultPath();
        String contextAlias = settings.getContextAlias();
        Monitor monitor = context.getMonitor();
        if (!config.getEntries().isEmpty()) {
            port = config.getInteger("port", port);
            path = config.getString("path", path);
        } else {
            monitor.warning(String.format("Settings for [%s] and/or [%s] were not provided. Using default value(s) instead.", apiConfig + ".path", apiConfig + ".path"), new Throwable[0]);
            if (settings.useDefaultContext()) {
                contextAlias = webServer.getDefaultContextName();
            } else {
                webServer.addPortMapping(contextAlias, port, path);
            }
        }
        monitor.info(String.format("%s will be available under port=%s, path=%s", settings.getName(), port, path), new Throwable[0]);
        return WebServiceConfiguration.Builder.newInstance().path(path).contextAlias(contextAlias).port(port).build();
    }
}

