/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.web.spi.exception;

import java.util.function.Function;
import org.eclipse.edc.spi.EdcException;
import org.eclipse.edc.spi.result.ServiceFailure;
import org.eclipse.edc.web.spi.exception.InvalidRequestException;
import org.eclipse.edc.web.spi.exception.NotAuthorizedException;
import org.eclipse.edc.web.spi.exception.ObjectConflictException;
import org.eclipse.edc.web.spi.exception.ObjectNotFoundException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceResultHandler {
    public static EdcException mapToException(@NotNull ServiceFailure failure, @NotNull Class<?> clazz) {
        return ServiceResultHandler.mapToException(failure, clazz, null);
    }

    public static EdcException mapToException(@NotNull ServiceFailure failure, @NotNull Class<?> clazz, @Nullable String id) {
        return switch (failure.getReason()) {
            default -> throw new IncompatibleClassChangeError();
            case ServiceFailure.Reason.NOT_FOUND -> new ObjectNotFoundException(clazz, id);
            case ServiceFailure.Reason.CONFLICT -> new ObjectConflictException(failure.getMessages());
            case ServiceFailure.Reason.BAD_REQUEST -> new InvalidRequestException(failure.getMessages());
            case ServiceFailure.Reason.UNAUTHORIZED -> new NotAuthorizedException(failure.getFailureDetail());
            case ServiceFailure.Reason.UNEXPECTED -> new EdcException(failure.getFailureDetail());
        };
    }

    public static Function<ServiceFailure, EdcException> exceptionMapper(@NotNull Class<?> clazz) {
        return serviceFailure -> ServiceResultHandler.mapToException(serviceFailure, clazz, null);
    }

    public static Function<ServiceFailure, EdcException> exceptionMapper(@NotNull Class<?> clazz, @Nullable String id) {
        return serviceFailure -> ServiceResultHandler.mapToException(serviceFailure, clazz, id);
    }
}

