/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.web.spi.configuration;

import java.util.Objects;

@Deprecated(since="0.11.0")
public class WebServiceSettings {
    private String apiConfigKey;
    private Integer defaultPort;
    private String defaultPath;
    private String contextAlias;

    private WebServiceSettings() {
    }

    public String apiConfigKey() {
        return this.apiConfigKey;
    }

    public Integer getDefaultPort() {
        return this.defaultPort;
    }

    public String getDefaultPath() {
        return this.defaultPath;
    }

    public String getContextAlias() {
        return this.contextAlias;
    }

    public int hashCode() {
        return Objects.hash(this.apiConfigKey, this.defaultPort, this.defaultPath, this.contextAlias);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebServiceSettings that = (WebServiceSettings)o;
        return this.apiConfigKey.equals(that.apiConfigKey) && this.defaultPort.equals(that.defaultPort) && this.defaultPath.equals(that.defaultPath) && Objects.equals(this.contextAlias, that.contextAlias);
    }

    public static class Builder {
        private final WebServiceSettings settings = new WebServiceSettings();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder contextAlias(String contextAlias) {
            this.settings.contextAlias = contextAlias;
            return this;
        }

        public Builder defaultPath(String defaultPath) {
            this.settings.defaultPath = defaultPath;
            return this;
        }

        public Builder apiConfigKey(String apiConfigKey) {
            this.settings.apiConfigKey = apiConfigKey;
            return this;
        }

        public Builder defaultPort(int defaultPort) {
            this.settings.defaultPort = defaultPort;
            return this;
        }

        public WebServiceSettings build() {
            Objects.requireNonNull(this.settings.apiConfigKey);
            Objects.requireNonNull(this.settings.contextAlias);
            Objects.requireNonNull(this.settings.defaultPort);
            if (this.settings.defaultPath == null) {
                this.settings.defaultPath = "/api/" + this.settings.contextAlias;
            }
            return this.settings;
        }
    }
}

