/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edc.connector.api.management.version.v1;

import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import org.eclipse.edc.spi.system.apiversion.VersionRecord;

@OpenAPIDefinition(info=@Info(description="This contains the version API that provides information about the exact version of the management API", title="Version API"))
@Tag(name="Version")
public interface VersionApi {
    @Operation(description="Gets the exact SemVer string of the Management API", responses={@ApiResponse(responseCode="200", description="The secret", content={@Content(schema=@Schema(implementation=SecretOutputSchema.class))})})
    public Map<String, List<VersionRecord>> getVersion();

    @ArraySchema
    @Schema(name="SecretOutput", example="{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"secret-id\",\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/Secret\",\n    \"value\": \"secret-value\"\n}\n")
    public record SecretOutputSchema(@Schema(name="@id") String id, @Schema(name="@type", example="https://w3id.org/edc/v0.0.1/ns/Secret") String type, @Schema(name="https://w3id.org/edc/v0.0.1/ns/value", requiredMode=Schema.RequiredMode.REQUIRED) String value) {
        public static final String SECRET_OUTPUT_EXAMPLE = "{\n    \"@context\": { \"@vocab\": \"https://w3id.org/edc/v0.0.1/ns/\" },\n    \"@id\": \"secret-id\",\n    \"@type\": \"https://w3id.org/edc/v0.0.1/ns/Secret\",\n    \"value\": \"secret-value\"\n}\n";
    }
}

